/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.rest.resources.v1;

import csbase.client.desktop.DesktopFrame;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.swing.SwingUtilities;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="v1/desktop")
@Api(value="Desktop", authorizations={@Authorization(value="Bearer", scopes={})})
public class DesktopRestService {
    @POST
    @Path(value="/shutdown")
    @ApiOperation(value="Shutdown the client Desktop", notes="This can only be done by the logged in user.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Token (Bearer $TOKEN)", dataType="string", required=true, paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation")})
    public Response shutdownDesktop() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                    DesktopFrame.getInstance().shutdownDesktop();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
        return Response.ok().entity((Object)"").build();
    }

    @POST
    @Path(value="/visible")
    @ApiOperation(value="Makes the client Desktop visible", notes="This can only be done by the logged in user.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Token (Bearer $TOKEN)", dataType="string", required=true, paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation")})
    public Response setDesktopVisible() {
        try {
            DesktopFrame.getInstance().setDesktopVisible(true);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).build();
        }
        return Response.ok().entity((Object)"").build();
    }

    @POST
    @Path(value="/invisible")
    @ApiOperation(value="Makes the client Desktop invisible", notes="This can only be done by the logged in user.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Token (Bearer $TOKEN)", dataType="string", required=true, paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation")})
    public Response setDesktopInvisible() {
        try {
            DesktopFrame.getInstance().setDesktopVisible(false);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).build();
        }
        return Response.ok().entity((Object)"").build();
    }
}

