/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree;

import csbase.client.applications.algorithmsmanager.versiontree.AbstractFileInfoNode;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.CommonAlgoFileRenameAction;
import csbase.client.applications.algorithmsmanager.versiontree.actions.CopyFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.EditExecutableFileAction;
import csbase.client.applications.algorithmsmanager.versiontree.actions.ExportExecutableFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.ImportExecutableFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.PasteFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.RemoveExecutableFiles;
import csbase.client.applications.algorithmsmanager.versiontree.actions.VersionWarningActionDecorator;
import csbase.logic.ClientAlgorithmFile;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutablePathFactory;
import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;
import tecgraf.javautils.core.lng.LNG;

public final class ExecutableFileNode
extends AbstractFileInfoNode {
    public static final DataFlavor DATA_FLAVOR = new DataFlavor(ExecutableFileNode.class, ExecutableFileNode.class.getSimpleName());
    private final String platform;

    public ExecutableFileNode(VersionTree tree, AlgorithmVersionInfo version, String platform, FileInfo file) {
        super(tree, version, file, file1 -> new ExecutableFileNode(tree, version, platform, file1), true);
        this.platform = platform;
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new CopyFile(this.getTree(), LNG.get((String)"algomanager.menu.bin_file.copy")))));
        if (this.getFile().isDirectory()) {
            popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new ImportExecutableFile(this.getTree(), this.getVersion(), this.platform, this.getExecFileDestPlatformPath()))));
            popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new PasteFile(this.getTree(), LNG.get((String)"algomanager.menu.bin_file.paste"), DATA_FLAVOR))));
            popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new CommonAlgoFileRenameAction(this.getTree()))));
        } else if (this.getTree().getSelectionCount() == 1) {
            popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new EditExecutableFileAction(this.getTree(), this.getVersion(), this.platform, this.getFile()))));
            popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new CommonAlgoFileRenameAction(this.getTree()))));
        }
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new RemoveExecutableFiles(this.getTree(), this.getVersion(), this.platform, this.getSelectedFiles()))));
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new ExportExecutableFile(this.getTree(), this.getVersion(), this.platform, this.getFile()))));
        return popupMenu;
    }

    private String getExecFileDestPlatformPath() {
        TreeNode[] nodes = this.getPath();
        if (nodes == null || nodes.length <= 0) {
            return null;
        }
        boolean platformNameFound = false;
        StringBuilder path = new StringBuilder();
        for (TreeNode node : nodes) {
            if (platformNameFound) {
                path.append('/');
                path.append(node.toString());
                continue;
            }
            if (!node.toString().equals(this.platform)) continue;
            platformNameFound = true;
        }
        return path.toString();
    }

    @Override
    public DataFlavor getDataFlavor() {
        return DATA_FLAVOR;
    }

    @Override
    protected final AbstractFileInfoNode.DataTransferObject createDataTransferObject() {
        return new ExecutableDTO(this);
    }

    @Override
    protected final IPathFactory createSourcePathFactory(AbstractFileInfoNode.DataTransferObject dto) {
        AlgorithmVersionInfo sourceVersion = dto.getVersion();
        String sourcePlatform = ((ExecutableDTO)dto).getPlatformName();
        return new ExecutablePathFactory(sourceVersion, sourcePlatform);
    }

    @Override
    protected final IPathFactory createTargetPathFactory() {
        return new ExecutablePathFactory(this.getVersion(), this.platform);
    }

    @Override
    public ClientAlgorithmFile.AlgorithmFileType getType() {
        return ClientAlgorithmFile.AlgorithmFileType.EXECUTABLE;
    }

    public String getPlatform() {
        return this.platform;
    }

    public static class ExecutableDTO
    extends AbstractFileInfoNode.DataTransferObject
    implements Serializable {
        private final String platform;

        public ExecutableDTO(ExecutableFileNode node) {
            super(node);
            this.platform = node.platform;
        }

        public String getPlatformName() {
            return this.platform;
        }
    }
}

