/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor.table.column;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.commandsmonitor.table.column.AbstractCommandsTableColumn;
import csbase.client.desktop.RemoteTask;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class DescriptionColumn
extends AbstractCommandsTableColumn {
    public DescriptionColumn(String id, ApplicationRegistry appRegistry) {
        super(String.class, id, appRegistry, true);
    }

    @Override
    public Object getValue(CommandInfo cmd) {
        if (cmd.getStatus() == CommandStatus.SYSTEM_FAILURE) {
            return null;
        }
        if (cmd.getDescription() == null) {
            return "";
        }
        return cmd.getDescription();
    }

    @Override
    public void setValue(final CommandInfo cmd, Object value) {
        String previousDescription = cmd.getDescription();
        String description = value.toString();
        cmd.setDescription(0 == description.length() ? null : description);
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws RemoteException {
                CommandsCache.getInstance().updateDescription(cmd);
            }
        };
        String taskTitle = this.getGenericString("task.command.update.title", new Object[0]);
        String taskMessage = this.getGenericString("task.command.update.message", new Object[0]);
        boolean success = task.execute(null, taskTitle, taskMessage);
        if (!success) {
            cmd.setDescription(previousDescription);
        }
    }

    @Override
    public TableCellRenderer createTableCellRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)comp;
                if (value == null) {
                    renderer.setText(DescriptionColumn.this.getDefaultErrorValue());
                    renderer.setIcon(null);
                } else {
                    renderer.setText(value.toString());
                    if (DescriptionColumn.this.isColumnEditable()) {
                        renderer.setIcon(ApplicationImages.ICON_EDITABLE_TABLE_CELL_14);
                    }
                }
                return this;
            }
        };
    }
}

