/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.desktoplauncher;

import csbase.client.applications.desktoplauncher.DesktopLauncher;
import csbase.client.applications.desktoplauncher.DesktopLauncherEvent;
import csbase.client.applications.desktoplauncher.DesktopLauncherEventDirection;
import csbase.client.openbus.OpenBusAccessPoint;
import csbase.client.openbus.OpenBusApplicationInstanceData;
import csbase.client.openbus.OpenBusEventHandler;
import csbase.client.openbus.OpenBusStandardEvents;
import csbase.exception.CSBaseException;
import java.rmi.RemoteException;
import tecgraf.javautils.core.lng.LNG;

public class DesktopLauncherEventHandler
extends OpenBusEventHandler {
    private boolean newDesktopReady = false;
    private boolean newApplicationReady = false;
    private boolean newProjectReady = false;
    private boolean closeChildDesktop = true;
    private final DesktopLauncher application;

    public final boolean fireDesktopVisibilityEvent(boolean flag) {
        if (!this.isNewDesktopReady()) {
            return false;
        }
        String sonId = this.getSonId();
        OpenBusStandardEvents sendEvent = OpenBusStandardEvents.DESKTOP_VISIBILITY_REQ;
        boolean sent = sendEvent.sendEvent(this, sonId, flag);
        return sent;
    }

    public final boolean fireRemoteApplication(String appId) {
        if (!this.isNewDesktopReady()) {
            return false;
        }
        boolean appDep = this.application.isInitalApplicationProjectDependent();
        String appDepTag = "application.needs.project.message";
        String appDepMsg = this.getString("application.needs.project.message") + ": " + appDep;
        this.application.log(appDepMsg);
        if (appDep && !this.isNewProjectReady()) {
            String appDepErrTag = "application.no.project.message";
            String appDepErrMsg = this.getString("application.no.project.message");
            this.application.log(appDepErrMsg);
            return false;
        }
        String sonId = this.getSonId();
        OpenBusStandardEvents sendType = OpenBusStandardEvents.APP_EXECUTION_REQ;
        boolean sent = sendType.sendEvent(this, sonId, appId);
        return sent;
    }

    public final boolean fireRemoteProject(String projectId) {
        if (!this.isNewDesktopReady()) {
            return false;
        }
        String sonId = this.getSonId();
        OpenBusStandardEvents sendType = OpenBusStandardEvents.PRJ_OPEN_REQ;
        boolean sent = sendType.sendEvent(this, sonId, projectId);
        return sent;
    }

    protected final DesktopLauncher getApplication() {
        return this.application;
    }

    protected final String getClassValueText(Object value) {
        String className = "NULL";
        if (value != null) {
            Class<?> clazz = value.getClass();
            className = clazz.getSimpleName();
        }
        return className;
    }

    protected final String getSonId() {
        String sonId = this.application.getSonId();
        return sonId;
    }

    protected final String getString(String tag) {
        String className = this.getClass().getSimpleName();
        String formattedTag = className + "." + tag;
        if (!this.application.hasString(formattedTag)) {
            return LNG.get((String)formattedTag);
        }
        String text = this.application.getString(formattedTag);
        return text;
    }

    protected final String getValueText(Object value) {
        String valueText = "null";
        if (value != null) {
            valueText = value.toString();
        }
        return valueText;
    }

    public final void init() {
        this.application.log(this.getString("init.message"));
        this.application.log(null);
        this.application.log(null);
        OpenBusStandardEvents launchType = OpenBusStandardEvents.DSKLAUNCHER_START_INFO;
        String sonId = this.getSonId();
        launchType.sendEvent(this, sonId, null);
    }

    protected final boolean isEventFromMySonId(String sourceId) {
        if (sourceId == null) {
            return false;
        }
        String sonId = this.getSonId();
        return sonId.equals(sourceId);
    }

    public final synchronized boolean isNewApplicationReady() {
        return this.newApplicationReady;
    }

    public final synchronized boolean isNewProjectReady() {
        return this.newProjectReady;
    }

    public final synchronized boolean isNewDesktopReady() {
        return this.newDesktopReady;
    }

    private void logDiscard(String sourceId, String destId, String type, String indicator) {
        String tag = "event.discard.message";
        String prefix = this.getString("event.discard.message");
        String headerText = prefix + ": " + type + " - " + indicator;
        String tailText = sourceId + " --> " + destId;
        this.application.log(headerText + " ::: " + tailText);
    }

    @Override
    public void logReceivedEvent(boolean treated, String sourceId, String destId, String type, Object value) {
        String className = this.getClassValueText(value);
        String valueText = this.getValueText(value);
        DesktopLauncherEventDirection direction = DesktopLauncherEventDirection.INPUT;
        DesktopLauncherEvent launcherEvent = new DesktopLauncherEvent(treated, direction, sourceId, type, className, valueText);
        this.application.addLauncherEvent(launcherEvent);
    }

    @Override
    public void logSentEvent(boolean treated, String sourceId, String destId, String type, Object value) {
        String className = this.getClassValueText(value);
        String valueText = this.getValueText(value);
        DesktopLauncherEventDirection direction = DesktopLauncherEventDirection.OUTPUT;
        DesktopLauncherEvent launcherEvent = new DesktopLauncherEvent(treated, direction, destId, type, className, valueText);
        this.application.addLauncherEvent(launcherEvent);
    }

    @Override
    public boolean receiveEventWithBooleanValue(String sourceId, String destId, String type, boolean booleanValue) {
        if (!this.isEventFromIdentifiedSourceAndToMe(sourceId, destId)) {
            String indicator = "(boolean)";
            this.logDiscard(sourceId, destId, type, "(boolean)");
            return false;
        }
        if (!this.isEventFromMySonId(sourceId)) {
            String indicator = "(boolean - not my son: " + sourceId + ")";
            this.logDiscard(sourceId, destId, type, indicator);
            return false;
        }
        OpenBusStandardEvents dskVisType = OpenBusStandardEvents.DESKTOP_VISIBILITY_INFO;
        if (dskVisType.isMyType(type)) {
            return this.handleDesktopVisibilityInfo();
        }
        return false;
    }

    @Override
    public boolean receiveEventWithNoValue(String sourceId, String destId, String type) {
        if (!this.isEventFromIdentifiedSourceAndToMe(sourceId, destId)) {
            String indicator = "(void)";
            this.logDiscard(sourceId, destId, type, "(void)");
            return false;
        }
        if (!this.isEventFromMySonId(sourceId)) {
            String indicator = "(void - not my son: " + sourceId + ")";
            this.logDiscard(sourceId, destId, type, indicator);
            return false;
        }
        OpenBusStandardEvents dskStartType = OpenBusStandardEvents.DESKTOP_START_INFO;
        if (dskStartType.isMyType(type)) {
            return this.handleDesktopStartInfo(sourceId);
        }
        OpenBusStandardEvents dskEndType = OpenBusStandardEvents.DESKTOP_END_INFO;
        if (dskEndType.isMyType(type)) {
            return this.handleDesktopEndInfo();
        }
        return false;
    }

    private boolean handleDesktopVisibilityInfo() {
        this.setCloseChildDesktopOnMyEnd(false);
        return true;
    }

    private boolean handleDesktopStartInfo(String sourceId) {
        if (this.isNewDesktopReady()) {
            String err = this.getString("second.desktop.detected.message");
            this.application.log(err + " - " + sourceId);
            this.fireDesktopShutdownEvent(sourceId);
            return true;
        }
        this.setNewDesktopReady(true);
        String err = this.getString("first.desktop.detected.message");
        this.application.log(err + " - " + sourceId);
        String projId = this.application.getInitialProjectId();
        if (projId != null) {
            boolean firedPrj = this.fireRemoteProject(projId);
            if (!firedPrj) {
                this.application.log(this.getString("project.not.fired.message"));
            }
            return true;
        }
        this.fireInitialApplication();
        return true;
    }

    private void fireInitialApplication() {
        boolean firedApp;
        String appId = this.application.getInitialApplicationId();
        if (appId != null && !(firedApp = this.fireRemoteApplication(appId))) {
            this.application.log(this.getString("application.not.fired.message"));
        }
    }

    private void waitSeconds(int sec) {
        this.application.log(this.getString("sleep.inited.message") + " (" + sec + "s)");
        try {
            Thread.sleep(1000 * sec);
        }
        catch (InterruptedException e) {
            this.application.log(this.getString("sleep.interrupted.message"));
        }
        this.application.log(this.getString("sleep.ended.message"));
    }

    private boolean handleDesktopEndInfo() {
        this.setNewApplicationReady(false);
        this.setNewProjectReady(false);
        this.setNewDesktopReady(false);
        this.application.closeApplication();
        return true;
    }

    private synchronized boolean isToCloseChildDesktopOnMyEnd() {
        return this.closeChildDesktop;
    }

    private final synchronized void setCloseChildDesktopOnMyEnd(boolean flag) {
        this.closeChildDesktop = flag;
    }

    @Override
    public boolean receiveEventWithStringValue(String sourceId, String destId, String type, String stringValue) {
        if (!this.isEventFromIdentifiedSourceAndToMe(sourceId, destId)) {
            String indicator = "(string)";
            this.logDiscard(sourceId, destId, type, "(string)");
            return false;
        }
        if (!this.isEventFromMySonId(sourceId)) {
            String indicator = "(string - not my son: " + sourceId + ")";
            this.logDiscard(sourceId, destId, type, indicator);
            return false;
        }
        OpenBusStandardEvents appStartType = OpenBusStandardEvents.APP_EXECUTION_SUCCESS_RSP;
        if (appStartType.isMyType(type)) {
            return this.handleAppExecutionSuccessResponse(stringValue);
        }
        OpenBusStandardEvents projOpenSuccessRsp = OpenBusStandardEvents.PRJ_OPEN_SUCCESS_RSP;
        if (projOpenSuccessRsp.isMyType(type)) {
            return this.handlePrjOpenSuccessResponse(stringValue);
        }
        OpenBusStandardEvents projOpenFailedRsp = OpenBusStandardEvents.PRJ_OPEN_FAILED_RSP;
        if (projOpenFailedRsp.isMyType(type)) {
            return this.handlePrjOpenFailedResponse(stringValue);
        }
        return false;
    }

    private boolean handlePrjOpenFailedResponse(String projId) {
        String initProjId = this.application.getInitialProjectId();
        if (initProjId != null) {
            if (initProjId.equals(projId)) {
                this.setNewProjectReady(false);
                String sufix = " - (" + projId + ")";
                String tag = "init.project.failure.opened.message";
                this.application.log(this.getString("init.project.failure.opened.message") + sufix);
            }
        } else {
            String sufix = " - (" + projId + ")";
            String tag = "project.failure.opened.message";
            this.application.log(this.getString("project.failure.opened.message") + sufix);
        }
        return true;
    }

    private boolean handlePrjOpenSuccessResponse(String launchedProjId) {
        String initProjId = this.application.getInitialProjectId();
        if (initProjId != null) {
            if (initProjId.equals(launchedProjId)) {
                this.setNewProjectReady(true);
                String sufix = " - (" + launchedProjId + ")";
                String tag = "init.project.correctly.opened.message";
                this.application.log(this.getString("init.project.correctly.opened.message") + sufix);
                this.fireInitialApplication();
            }
        } else {
            String sufix = " - (" + launchedProjId + ")";
            String tag = "project.correctly.opened.message";
            this.application.log(this.getString("project.correctly.opened.message") + sufix);
        }
        return true;
    }

    private boolean handleAppExecutionSuccessResponse(String stringValue) {
        String[] idsFromEventValue = OpenBusApplicationInstanceData.getIdsFromEventValue(stringValue);
        String badAppIdTag = "application.id.started.inconsistent.event.message";
        if (idsFromEventValue == null) {
            this.application.log(this.getString("application.id.started.inconsistent.event.message"));
            return false;
        }
        String lanchedAppId = idsFromEventValue[0];
        if (lanchedAppId == null) {
            this.application.log(this.getString("application.id.started.inconsistent.event.message"));
            return false;
        }
        String lanchedInstanceId = idsFromEventValue[1];
        if (lanchedInstanceId == null) {
            String badInstIdTag = "instance.id.started.inconsistent.event.message";
            this.application.log(this.getString("instance.id.started.inconsistent.event.message"));
            return false;
        }
        String initAppId = this.application.getInitialApplicationId();
        if (initAppId != null) {
            if (initAppId.equals(lanchedAppId)) {
                this.setNewApplicationReady(true);
                String sufix = " - (" + lanchedInstanceId + ")";
                String tag = "init.application.correctly.started.message";
                this.application.log(this.getString("init.application.correctly.started.message") + sufix);
            }
        } else {
            String sufix = " - (" + lanchedInstanceId + ")";
            String tag = "application.correctly.started.message";
            this.application.log(this.getString("application.correctly.started.message") + sufix);
        }
        return true;
    }

    private synchronized void setNewApplicationReady(boolean flag) {
        this.newApplicationReady = flag;
        if (flag) {
            this.application.log(this.getString("init.application.ready.message"));
        } else {
            this.application.log(this.getString("init.application.not.ready.message"));
        }
    }

    private synchronized void setNewProjectReady(boolean flag) {
        this.newProjectReady = flag;
        if (flag) {
            this.application.log(this.getString("init.project.ready.message"));
        } else {
            this.application.log(this.getString("init.project.not.ready.message"));
        }
    }

    private final synchronized void setNewDesktopReady(boolean flag) {
        this.newDesktopReady = flag;
        if (flag) {
            this.application.log(this.getString("desktop.ready.message"));
        } else {
            this.application.log(this.getString("desktop.not.ready.message"));
        }
    }

    public void shutdown() throws Exception {
        this.application.log(this.getString("shutdown.message"));
        if (this.isNewDesktopReady()) {
            this.fireLauncherEndEvent();
        } else {
            String tag = "kill.launcher.no.event.message";
            String msg = this.getString("kill.launcher.no.event.message");
            this.application.log(msg);
        }
        this.waitSeconds(1);
        if (this.isToCloseChildDesktopOnMyEnd()) {
            String sonId = this.getSonId();
            this.fireDesktopShutdownEvent(sonId);
        }
        this.unlinkToOpenBus();
    }

    protected final void fireLauncherEndEvent() {
        String sonId = this.getSonId();
        this.application.log(this.getString("kill.launcher.event.message"));
        OpenBusStandardEvents launchType = OpenBusStandardEvents.DSKLAUNCHER_END_INFO;
        boolean sent = launchType.sendEvent(this, sonId, null);
        if (!sent) {
            String tag = "dsklauncher.end.event.not.sent.message";
            String msg = this.getString("dsklauncher.end.event.not.sent.message");
            this.application.log(msg);
        } else {
            String tag = "dsklauncher.end.event.sent.message";
            String msg = this.getString("dsklauncher.end.event.sent.message");
            this.application.log(msg);
        }
    }

    protected final void unlinkToOpenBus() throws CSBaseException, RemoteException {
        OpenBusAccessPoint oap = OpenBusAccessPoint.getInstance();
        oap.getSession().delEventReceiver(this);
    }

    public final boolean fireDesktopShutdownEvent(String desktopId) {
        OpenBusStandardEvents evType = OpenBusStandardEvents.DESKTOP_SHUTDOWN_REQ;
        boolean sent = evType.sendEvent(this, desktopId, null);
        this.setNewApplicationReady(false);
        this.setNewProjectReady(false);
        this.setNewDesktopReady(false);
        return sent;
    }

    public DesktopLauncherEventHandler(DesktopLauncher application) {
        if (application == null) {
            String err = "null application not allowed!";
            throw new IllegalArgumentException("null application not allowed!");
        }
        this.application = application;
        this.setNewDesktopReady(false);
        this.setNewApplicationReady(false);
        this.setNewProjectReady(false);
        application.log(this.getString("created.message"));
    }
}

