/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.executorlocal;

import csbase.client.applications.ApplicationProject;
import csbase.client.desktop.DesktopFrame;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import tecgraf.javautils.core.externalcommand.ExternalCommand;

public class ExecutorLocal
extends ApplicationProject {
    private Thread exec;
    private ClientProjectFile fileToOpen;

    public ExecutorLocal(String id) {
        super(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeLocal() {
        DesktopFrame desktop = DesktopFrame.getInstance();
        ExternalCommand command = null;
        String appCommand = this.getCommand();
        String appDir = this.getApplicationCommandDir();
        System.out.println("Caminho da aplica\u00e7\u00e3o:" + appDir);
        File workingDir = new File(appDir);
        try {
            command = new ExternalCommand(appCommand, null, workingDir);
            if (command.waitFor() == 0) {
                System.out.println("A aplica\u00e7\u00e3o terminou OK");
            }
        }
        catch (InterruptedException e) {
            if (command != null) {
                command.destroy();
            }
        }
        catch (IOException e) {
            StandardErrorDialogs.showErrorDialog((Window)desktop.getDesktopFrame(), this.getName(), this.getString("msg.error.io"));
        }
        catch (SecurityException e) {
            StandardErrorDialogs.showErrorDialog((Window)desktop.getDesktopFrame(), this.getName(), this.getString("msg.error.security"));
        }
        finally {
            this.finishApplication();
        }
    }

    private String getCommand() {
        DesktopFrame desktop = DesktopFrame.getInstance();
        String server = ClientRemoteMonitor.getInstance().getServerPath();
        String project = desktop.getProject().getName();
        String owner = (String)desktop.getProject().getUserId();
        String user = (String)User.getLoggedUser().getId();
        String pass = ClientRemoteMonitor.getInstance().getPassword();
        String[] srvPort = server.split(":");
        String wioPort = this.getWIOPort();
        String file = this.getFilePath();
        String[][] aParam = new String[][]{{"USER", "PASS", "SERVER", "PORT", "PROJECT", "WIO", "OWNER", "FILE"}, {user, pass, srvPort[0], srvPort[1], project, wioPort, owner, file}};
        String appCommand = this.getApplicationCommand();
        for (int i = 0; i < aParam[0].length; ++i) {
            appCommand = appCommand.replaceAll(aParam[0][i], aParam[1][i]);
        }
        return appCommand;
    }

    private String getWIOPort() {
        try {
            String port = ClientRemoteLocator.wioService.getServerPort();
            if (port == null) {
                return "";
            }
            return port;
        }
        catch (Exception e) {
            DesktopFrame desktop = DesktopFrame.getInstance();
            StandardErrorDialogs.showErrorDialog((Window)desktop.getDesktopFrame(), desktop.getTitle(), this.getString("msg.error.paramwio"));
            return "";
        }
    }

    private String getFilePath() {
        if (this.fileToOpen == null) {
            return "";
        }
        return this.fileToOpen.getStringPath();
    }

    private Thread createExecuteThread() {
        Thread newThread = new Thread(){

            @Override
            public void run() {
                ExecutorLocal.this.executeLocal();
            }
        };
        return newThread;
    }

    @Override
    public void killApplication() {
        try {
            this.exec.interrupt();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public boolean userCanKillApplication() {
        return true;
    }

    @Override
    public void postInitialization() {
        this.exec = this.createExecuteThread();
        this.exec.start();
    }

    @Override
    public void sendMessage(String name, Object value, String senderId) {
        if (value == null) {
            return;
        }
        if (name.equals("PROJECT_FILE")) {
            this.fileToOpen = (ClientProjectFile)value;
        }
    }
}

