/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransferclient.actions;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferClientUI;
import csbase.client.applications.filetransferclient.FileTransferProxy;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.localpanel.FileTransferClientLocalPanel;
import csbase.client.applications.filetransferclient.panels.queuepanel.FileTransferClientQueuePanel;
import csbase.client.applications.filetransferclient.panels.remotepanel.FileTransferClientRemotePanel;
import csbase.logic.ClientProjectFile;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferElement;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class DownloadAction
extends FileTransferClientAction {
    @Override
    public final void actionDone(JComponent component) {
        FileTransferClient app = (FileTransferClient)this.getApplication();
        FileTransferClientRemotePanel remotePanel = app.getRemotePanel();
        FileTransferClientLocalPanel localPanel = app.getLocalPanel();
        List<FileTransferElement> selFiles = remotePanel.getSelectedElements();
        if (selFiles == null || selFiles.size() <= 0) {
            return;
        }
        for (FileTransferElement selFile : selFiles) {
            if (selFile == null || selFile.isDirectory()) continue;
            String fileName = selFile.getName();
            String remoteDir = remotePanel.getRemoteDirectory();
            String remotePath = remoteDir + "/" + fileName;
            ClientProjectFile localDirectory = localPanel.getLocalDirectory();
            String localDir = FileTransferClientUI.pathToString(localDirectory);
            String localPath = FileTransferClientUI.isEmptyString(localDir) ? fileName : localDir + "/" + fileName;
            String lPath = localPath;
            while (lPath.startsWith("/")) {
                lPath = lPath.substring(1);
            }
            String[] localFilePath = lPath.split("/");
            FileTransferProxy serviceProxy = app.getServiceProxy();
            FileTransferConnection connection = app.getConnection();
            long size = selFile.getSizeBytes();
            serviceProxy.download(connection, remotePath, localFilePath, size);
            localPanel.refresh();
            FileTransferClientQueuePanel queuePanel = app.getQueuePanel();
            queuePanel.refresh();
        }
    }

    @Override
    public final ImageIcon getStandardImageIcon() {
        return ApplicationImages.ICON_LEFT_16;
    }

    public DownloadAction(FileTransferClient application) {
        super(application);
    }
}

