/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransferclient.actions.core;

import csbase.client.applications.ApplicationAction;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferClientUI;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public abstract class FileTransferClientAction
extends ApplicationAction<FileTransferClient> {
    public final String getString(String tag) {
        FileTransferClient ftpClient = (FileTransferClient)this.getApplication();
        Class<?> cls = this.getClass();
        String prefix = cls.getSimpleName();
        return ftpClient.getString(prefix + "." + tag);
    }

    public final boolean hasString(String tag) {
        FileTransferClient ftpClient = (FileTransferClient)this.getApplication();
        Class<?> cls = this.getClass();
        String prefix = cls.getSimpleName();
        return ftpClient.hasString(prefix + "." + tag);
    }

    public final String getName() {
        String TAG_NAME = "name";
        if (!this.hasString("name")) {
            return null;
        }
        return this.getString("name");
    }

    public final String getToolTipText() {
        String TAG_TOOLTIP = "tooltip";
        if (!this.hasString("tooltip")) {
            return null;
        }
        return this.getString("tooltip");
    }

    public final Integer getMnemonic() {
        String TAG_MNEMONIC = "mnemonic";
        if (!this.hasString("mnemonic")) {
            return null;
        }
        String mn = this.getString("mnemonic");
        if (mn == null || FileTransferClientUI.isEmptyString(mn)) {
            return null;
        }
        return mn.charAt(0);
    }

    private final ImageIcon getImageIcon() {
        ImageIcon stdIcon = this.getStandardImageIcon();
        if (stdIcon != null) {
            return stdIcon;
        }
        String IMG_ACTION_DIR = "actions";
        String prefix = this.getClass().getSimpleName();
        String name = prefix + ".16";
        String pth = "actions/" + name;
        ImageIcon icon = ((FileTransferClient)this.getApplication()).buildApplicationImage(pth);
        if (icon == ApplicationImages.ICON_NONE) {
            return null;
        }
        return icon;
    }

    @Override
    public final void actionPerformed(ActionEvent ae) {
        try {
            JComponent cmp = (JComponent)ae.getSource();
            this.actionDone(cmp);
        }
        catch (Exception e) {
            FileTransferClient application = (FileTransferClient)this.getApplication();
            application.showExceptionDialog(e);
        }
    }

    public FileTransferClientAction(FileTransferClient ftpClient) {
        super(ftpClient);
        String tooltip;
        ImageIcon icon;
        Integer mnemonic;
        String name = this.getName();
        if (name != null) {
            this.putValue("Name", name);
        }
        if ((mnemonic = this.getMnemonic()) != null) {
            this.putValue("MnemonicKey", mnemonic);
        }
        if ((icon = this.getImageIcon()) != null) {
            this.putValue("SmallIcon", icon);
        }
        if ((tooltip = this.getToolTipText()) != null) {
            this.putValue("ShortDescription", tooltip);
        }
    }

    public abstract void actionDone(JComponent var1) throws Exception;

    public abstract ImageIcon getStandardImageIcon();
}

