/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager;

import csbase.client.applications.projectsmanager.AbstractProjectsManagerObserver;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.remote.ProjectAdminObserver;
import csbase.logic.AdministrationEvent;
import csbase.logic.CommonProjectInfo;
import csbase.logic.ProjectUserEvent;
import java.util.Observable;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class ProjectCreationRemovalObserver
extends AbstractProjectsManagerObserver {
    public ProjectCreationRemovalObserver(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public void update(Observable o, Object arg) {
        int type;
        CommonProjectInfo cpi;
        if (o == null) {
            return;
        }
        if (!(o instanceof ProjectAdminObserver) || !(arg instanceof ProjectUserEvent)) {
            return;
        }
        if (arg instanceof ProjectUserEvent) {
            ProjectUserEvent pue = (ProjectUserEvent)arg;
            cpi = (CommonProjectInfo)pue.item;
            type = pue.type;
        } else {
            AdministrationEvent ae = (AdministrationEvent)arg;
            cpi = (CommonProjectInfo)ae.item;
            type = ae.type;
        }
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ProjectsManagerData pmd = ProjectCreationRemovalObserver.this.projectsManager.getProject(cpi);
                if (type == 1) {
                    if (pmd != null) {
                        return;
                    }
                    ProjectCreationRemovalObserver.this.addProject(cpi);
                } else if (type == 2 && pmd != null) {
                    ProjectSpaceAllocation psa = pmd.getProjectSpaceAllocation();
                    if (psa == ProjectSpaceAllocation.ALLOCATED) {
                        pmd.setProjectSpaceAllocation(ProjectSpaceAllocation.WAITING_DEALLOCATION);
                    } else if (psa != ProjectSpaceAllocation.WAITING_DEALLOCATION) {
                        ProjectCreationRemovalObserver.this.projectsManager.removeProject(cpi);
                    }
                }
            }
        });
    }
}

