/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.panels;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.panels.AbstractProjectManagerInfoPanel;
import csbase.client.applications.projectsmanager.panels.MultipleSelectionPanel;
import csbase.client.applications.projectsmanager.panels.ProjectsManagerPanel;
import csbase.client.applications.projectsmanager.panels.SingleSelectionPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.List;

public class InfoPanel
extends ProjectsManagerPanel {
    private final CardLayout cardLayout = new CardLayout();
    private final SingleSelectionPanel singleSelectionPanel;
    private final MultipleSelectionPanel multipleSelectionPanel;
    private static final String SINGLE_SELECTION_PANEL = "SingleSelectionPanel";
    private static final String MULTIPLE_SELECTION_PANEL = "MultipleSelectionPanel";
    private AbstractProjectManagerInfoPanel currentPanel;

    public InfoPanel(ProjectsManager projectsManager) {
        super(projectsManager);
        this.singleSelectionPanel = new SingleSelectionPanel(projectsManager);
        this.multipleSelectionPanel = new MultipleSelectionPanel(projectsManager);
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(this.cardLayout);
        this.add((Component)this.singleSelectionPanel, SINGLE_SELECTION_PANEL);
        this.cardLayout.addLayoutComponent(this.singleSelectionPanel, SINGLE_SELECTION_PANEL);
        this.add((Component)this.multipleSelectionPanel, MULTIPLE_SELECTION_PANEL);
        this.cardLayout.addLayoutComponent(this.multipleSelectionPanel, MULTIPLE_SELECTION_PANEL);
    }

    public void clearFields() {
        this.singleSelectionPanel.clearFields();
        this.multipleSelectionPanel.clearFields();
    }

    public void setSelectedProjects(List<ProjectsManagerData> selectedProjects) {
        if (selectedProjects == null) {
            return;
        }
        if (selectedProjects.size() == 1) {
            this.currentPanel = this.singleSelectionPanel;
            this.singleSelectionPanel.setProjectsManagerData(selectedProjects.get(0));
            this.cardLayout.show(this, SINGLE_SELECTION_PANEL);
        } else {
            this.currentPanel = this.multipleSelectionPanel;
            this.multipleSelectionPanel.setProjectsManagerData(selectedProjects);
            this.cardLayout.show(this, MULTIPLE_SELECTION_PANEL);
        }
        this.revalidate();
        this.repaint();
    }

    public void updateFields() {
        this.currentPanel.updateFields();
    }
}

