/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.panels.filters;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.panels.filters.AbstractProjectFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.KeyListener;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.calendar.CalendarDateField;
import tecgraf.javautils.gui.calendar.CalendarEvent;
import tecgraf.javautils.gui.calendar.CalendarListener;
import tecgraf.javautils.gui.calendar.CalendarPanel;

abstract class AbstractProjectDateFilter
extends AbstractProjectFilter {
    private CalendarDateField cdfInitial;
    private CalendarDateField cdfFinal;
    private JLabel fromDateLabel;
    private JLabel untilDateLabel;
    private JPanel fromPanel;
    private JPanel untilPanel;
    private JLabel mainLabel;
    private static final long EARLIEST_DATE = 0L;
    private static final long LATEST_DATE = Long.MAX_VALUE;

    public AbstractProjectDateFilter(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    private long prepareDateForComparison(Date date, long defaultValue) {
        return date != null ? date.getTime() : defaultValue;
    }

    @Override
    public void runSpecificFilter(List<ProjectsManagerData> allProjects, List<ProjectsManagerData> filteredProjects) {
        long initialDate = this.prepareDateForComparison(this.cdfInitial.getDate(), 0L);
        long finalDate = this.prepareDateForComparison(this.cdfFinal.getDate(), Long.MAX_VALUE);
        if (initialDate < 0L || finalDate < 0L || initialDate > finalDate) {
            return;
        }
        for (ProjectsManagerData pmd : allProjects) {
            if (!this.projectMatchesFilter(initialDate, finalDate, pmd)) continue;
            filteredProjects.add(pmd);
        }
    }

    protected abstract boolean projectMatchesFilter(long var1, long var3, ProjectsManagerData var5);

    @Override
    public boolean projectMatchesFilter(ProjectsManagerData prj) {
        long initialDate = this.prepareDateForComparison(this.cdfInitial.getDate(), 0L);
        long finalDate = this.prepareDateForComparison(this.cdfFinal.getDate(), Long.MAX_VALUE);
        if (initialDate < 0L || finalDate < 0L || initialDate > finalDate) {
            return false;
        }
        return this.projectMatchesFilter(initialDate, finalDate, prj);
    }

    @Override
    public void addListener(KeyListener kl) {
        JTextField initialField = this.cdfInitial.getField();
        initialField.addKeyListener(kl);
        JTextField finalField = this.cdfFinal.getField();
        finalField.addKeyListener(kl);
        final ProjectsManager projectsManager = this.getProjectsManager();
        CalendarListener initialCalendarListener = new CalendarListener(){

            public void dateSelected(CalendarEvent arg0) {
                AbstractProjectDateFilter.this.cdfInitial.setDate(new Date(arg0.getDate()));
                projectsManager.runFilters(true);
            }
        };
        CalendarListener finalCalendarListener = new CalendarListener(){

            public void dateSelected(CalendarEvent arg0) {
                AbstractProjectDateFilter.this.cdfFinal.setDate(new Date(arg0.getDate()));
                projectsManager.runFilters(true);
            }
        };
        CalendarPanel initialPanel = this.cdfInitial.getCalendar();
        initialPanel.addCalendarListener(initialCalendarListener);
        CalendarPanel finalPanel = this.cdfFinal.getCalendar();
        finalPanel.addCalendarListener(finalCalendarListener);
    }

    @Override
    public void emptyFilterData() {
        JTextField initialField = this.cdfInitial.getField();
        initialField.setText("");
        JTextField finalField = this.cdfFinal.getField();
        finalField.setText("");
    }

    public JPanel getFromPanel() {
        return this.fromPanel;
    }

    public JPanel getUntilPanel() {
        return this.untilPanel;
    }

    @Override
    protected void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.fromPanel = new JPanel(new GridBagLayout());
        this.fromPanel.add((Component)this.fromDateLabel, new GBC(0, 0));
        this.fromPanel.add((Component)this.cdfInitial, new GBC(1, 0).horizontal().insets(0, 10, 0, 10));
        this.untilPanel = new JPanel(new GridBagLayout());
        this.untilPanel.add((Component)this.untilDateLabel, new GBC(1, 0));
        this.untilPanel.add((Component)this.cdfFinal, new GBC(2, 0).horizontal().insets(0, 10, 0, 0));
        this.add((Component)this.fromPanel, new GBC(0, 0).horizontal());
        this.add((Component)this.untilPanel, new GBC(1, 0).horizontal());
    }

    public JLabel getMainLabel() {
        return this.mainLabel;
    }

    @Override
    protected void initComponents() {
        this.cdfInitial = new CalendarDateField();
        this.cdfFinal = new CalendarDateField();
        this.fromDateLabel = new JLabel(this.getClassString("initial.date.label"));
        this.untilDateLabel = new JLabel(this.getClassString("final.date.label"));
        this.mainLabel = this.createMainLabel();
        this.fromDateLabel.setForeground(Color.GRAY);
        this.untilDateLabel.setForeground(Color.GRAY);
    }

    protected abstract JLabel createMainLabel();
}

