/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.commandtable;

import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import javax.swing.Icon;

public class CommandStatusCellData
implements Comparable<CommandStatusCellData> {
    protected Icon icon;
    protected String tooltip;
    protected CommandInfo cmdInfo;

    public CommandStatusCellData(CommandInfo cmdInfo, Icon icon, String tooltip) {
        this.icon = icon;
        this.tooltip = tooltip;
        this.cmdInfo = cmdInfo;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public CommandInfo getCmdInfo() {
        return this.cmdInfo;
    }

    public boolean equals(Object o) {
        CommandStatusCellData anotherData;
        return o != null && o instanceof CommandStatusCellData && this.cmdInfo.equals((Object)(anotherData = (CommandStatusCellData)o).getCmdInfo());
    }

    public int hashCode() {
        return this.cmdInfo.getId().hashCode();
    }

    @Override
    public int compareTo(CommandStatusCellData anotherCellData) {
        CommandInfo anotherCmdInfo = anotherCellData.getCmdInfo();
        if (anotherCmdInfo == null) {
            return -1;
        }
        CommandStatus status = this.cmdInfo.getStatus();
        if (status == null) {
            return 1;
        }
        CommandStatus anotherStatus = anotherCmdInfo.getStatus();
        int statusComparison = status.compareTo((Enum)anotherStatus);
        if (statusComparison == 0) {
            if (status == CommandStatus.EXECUTING) {
                if (this.cmdInfo.isQueued() && !anotherCmdInfo.isQueued()) {
                    return 1;
                }
                if (!this.cmdInfo.isQueued() && anotherCmdInfo.isQueued()) {
                    return -1;
                }
                if (this.cmdInfo.isValid() && !anotherCmdInfo.isValid()) {
                    return 1;
                }
                if (!this.cmdInfo.isValid() && anotherCmdInfo.isValid()) {
                    return -1;
                }
            }
            if (status == CommandStatus.FINISHED) {
                CommandFinalizationType anotherFinalizationType = anotherCmdInfo.getFinalizationType();
                CommandFinalizationType finalizationType = this.cmdInfo.getFinalizationType();
                if (finalizationType != null) {
                    return finalizationType.compareTo((Enum)anotherFinalizationType);
                }
            }
        }
        return statusComparison;
    }
}

