/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.configurabletable.column;

import csbase.client.facilities.configurabletable.column.IConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import java.util.Comparator;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractConfigurableColumn<T>
implements IConfigurableColumn<T> {
    private String id;
    private boolean visible;
    private IStringProvider stringProvider;
    private int align;
    public static String NO_VALUE = "---";

    protected AbstractConfigurableColumn(String id, Boolean visible, IStringProvider stringProvider, Integer align) {
        if (id == null) {
            throw new IllegalArgumentException("id n\u00e3o pode ser nulo.");
        }
        this.id = id;
        this.visible = visible == null ? false : visible;
        this.stringProvider = stringProvider;
        int n = this.align = align == null ? 0 : align;
        if (stringProvider == null) {
            this.stringProvider = new IStringProvider(){

                @Override
                public String getString(String key) {
                    return key;
                }
            };
        }
    }

    protected String getString(String key) {
        return this.stringProvider.getString(key);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public int getAlign() {
        return this.align;
    }

    public boolean isEditable(T obj) {
        return false;
    }

    public void setValue(T obj, Object value) {
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public Comparator<?> getComparator() {
        return null;
    }

    public TableCellRenderer createTableCellRenderer() {
        return null;
    }

    public TableCellEditor createTableCellEditor() {
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("id:");
        builder.append(this.getId());
        builder.append(";visible:");
        builder.append(this.isVisible());
        builder.append(";align:");
        builder.append(this.getAlign());
        builder.append(";string-provider:");
        builder.append(this.stringProvider.toString());
        return builder.toString();
    }
}

