/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.openbus;

import csbase.client.Client;
import csbase.client.login.InitialContext;
import csbase.client.login.LoginInterface;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.exception.CSBaseException;
import csbase.logic.openbus.OpenBusLoginToken;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;
import tecgraf.javautils.gui.StandardDialogs;

public final class OpenBusLogin
implements LoginInterface {
    private InitialContext context;
    private OpenBusLoginToken token;

    public OpenBusLogin(InitialContext context) {
        this.context = context;
        Client client = Client.getInstance();
        String user = client.getParameter("openbus_token_user");
        byte[] secret = Base64.decodeBase64((String)client.getParameter("openbus_token_secret"));
        this.token = new OpenBusLoginToken(user, secret);
    }

    @Override
    public InitialContext login(Locale defaultLocale, String systemName) {
        ClientRemoteMonitor.getInstance().getServerLookupThread().start();
        try {
            ClientRemoteMonitor.getInstance().start(this.token, defaultLocale);
            if (!ClientRemoteMonitor.getInstance().isAlive()) {
                StandardDialogs.showErrorDialog(null, (String)systemName, (String)"Login ou senha inv\u00e1lidos.");
                return null;
            }
        }
        catch (CSBaseException e) {
            StandardDialogs.showErrorDialog(null, (String)systemName, (String)"N\u00e3o foi poss\u00edvel acessar o servidor. Provavelmente o servidor est\u00e1 fora do ar.");
            e.printStackTrace();
            return null;
        }
        return this.context;
    }

    @Override
    public void notifyException(Exception e) {
    }

    @Override
    public void notifyInitialized() {
    }

    @Override
    public void notifyPreInitialization() {
    }

    @Override
    public String getClientInstanceId() {
        Client client = Client.getInstance();
        String paramName = "current_client_identifier";
        String id = client.getParameter("current_client_identifier");
        return id;
    }

    @Override
    public String getFatherClientInstanceId() {
        Client client = Client.getInstance();
        String paramName = "source_client_identifier";
        String id = client.getParameter("source_client_identifier");
        return id;
    }
}

