/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.project.ProjectFileContainer;
import csbase.client.project.action.CommonFileExportAction;
import csbase.logic.ClientProjectFile;
import java.awt.event.ActionEvent;
import java.io.File;
import java.security.AccessControlException;
import javax.swing.JFileChooser;
import tecgraf.javautils.core.io.FileUtils;

public class SingleFileExportAction
extends CommonFileExportAction {
    public SingleFileExportAction(ProjectFileContainer container) {
        super(container);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ClientProjectFile selectedFile = this.getSelectedFile();
        if (selectedFile == null || selectedFile.isDirectory()) {
            return;
        }
        long fileSize = this.getFileSize(selectedFile);
        if (fileSize == -1L) {
            return;
        }
        if (fileSize == 0L && !this.confirmEmptyFileExport(selectedFile)) {
            return;
        }
        try {
            File userTarget = this.getUserTarget(selectedFile);
            if (userTarget == null) {
                return;
            }
            if (userTarget.exists()) {
                if (!this.confirmOverwrite(userTarget)) {
                    return;
                }
                FileUtils.delete((File)userTarget);
            }
            this.transferFile(selectedFile, userTarget);
        }
        catch (AccessControlException ex1) {
            this.transferFileUsingJNLP(selectedFile);
        }
    }

    private File getUserTarget(ClientProjectFile clientFile) {
        JFileChooser chooser = this.getFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setSelectedFile(new File(chooser.getCurrentDirectory() + File.separator + clientFile.getName()));
        int result = chooser.showSaveDialog(this.getWindow());
        if (result == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }
}

