/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.dialogs;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.RemoteTask;
import csbase.client.openbus.OpenBusAccessPoint;
import csbase.exception.CSBaseException;
import csbase.logic.ClientProjectFile;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.StatusBar;

public final class UpdateFileDialog
extends DesktopComponentDialog {
    private ClientProjectFile file;
    private JTextField intervalField;
    private JButton stopButton;
    private JCheckBox notificationBox;

    public UpdateFileDialog(JFrame owner, ClientProjectFile file) {
        super((Window)owner, MessageFormat.format(UpdateFileDialog.getString("title"), file.getName()));
        this.file = file;
        this.createGui();
    }

    private void createGui() {
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UpdateFileDialog.this.close();
            }
        });
        JLabel intervalLabel = new JLabel(UpdateFileDialog.getString("interval"));
        long interval = this.file.getUpdateInterval();
        String intervalText = interval > 0L ? String.valueOf(interval) : "";
        this.intervalField = new JTextField(intervalText, 5);
        JLabel secondsLabel = new JLabel(UpdateFileDialog.getString("seconds"));
        this.notificationBox = new JCheckBox(UpdateFileDialog.getString("notification"));
        String text = interval > 0L ? MessageFormat.format(UpdateFileDialog.getString("update.status.user"), this.file.getUpdateUserLogin()) : UpdateFileDialog.getString("update.status.none");
        StatusBar statusBar = new StatusBar();
        statusBar.setText(text);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel intervalPanel = new JPanel(new GridBagLayout());
        intervalPanel.add((Component)intervalLabel, new GBC(0, 0).none().insets(0, 0, 0, 6).west());
        intervalPanel.add((Component)this.intervalField, new GBC(1, 0).horizontal().insets(0, 6, 0, 6).west());
        intervalPanel.add((Component)secondsLabel, new GBC(2, 0).none().insets(0, 6, 0, 0).west());
        mainPanel.add((Component)intervalPanel, new GBC(0, 0).west().horizontal().insets(11, 11, 6, 11));
        mainPanel.add((Component)this.notificationBox, new GBC(0, 1).west().horizontal().insets(6, 11, 6, 11));
        mainPanel.add((Component)this.makeButtonPanel(), new GBC(0, 2).center().horizontal().insets(6, 11, 6, 11));
        JPanel statusPanel = new JPanel(new GridBagLayout());
        statusPanel.add((Component)statusBar, new GBC(0, 0).horizontal().insets(1, 1, 1, 1).west());
        statusPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        mainPanel.add((Component)statusPanel, new GBC(0, 3).center().horizontal().insets(6, 0, 0, 0));
        this.getContentPane().add(mainPanel);
        this.setResizable(false);
        this.pack();
        this.center(this.getOwner());
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        String startButtonTitle = this.file.getUpdateInterval() == 0L ? UpdateFileDialog.getString("start") : UpdateFileDialog.getString("update");
        JButton startButton = (JButton)panel.add(new JButton(startButtonTitle));
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UpdateFileDialog.this.handleStartAction()) {
                    UpdateFileDialog.this.close();
                }
            }
        });
        this.stopButton = (JButton)panel.add(new JButton(UpdateFileDialog.getString("stop")));
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UpdateFileDialog.this.handleStopAction()) {
                    UpdateFileDialog.this.close();
                }
            }
        });
        JButton cancelButton = (JButton)panel.add(new JButton(UpdateFileDialog.getString("close")));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateFileDialog.this.close();
            }
        });
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{startButton, this.stopButton, cancelButton});
        this.getRootPane().setDefaultButton(startButton);
        if (this.file.getUpdateInterval() == 0L) {
            this.stopButton.setEnabled(false);
        } else {
            this.stopButton.setEnabled(true);
        }
        return panel;
    }

    private boolean handleStartAction() {
        int interval;
        String text = this.intervalField.getText();
        try {
            interval = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            interval = -1;
        }
        if (interval <= 0) {
            StandardDialogs.showErrorDialog((Component)this, (String)MessageFormat.format(UpdateFileDialog.getString("invalid.interval.title"), this.getTitle()), (String)UpdateFileDialog.getString("invalid.interval.message"));
            return false;
        }
        final int updateInterval = interval;
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws RemoteException, CSBaseException {
                OpenBusAccessPoint oap = OpenBusAccessPoint.getInstance();
                oap.init();
                byte[] chain = oap.makeChain();
                ClientRemoteLocator.projectService.startUpdate(UpdateFileDialog.this.file.getProjectId(), UpdateFileDialog.this.file.getPath(), (long)updateInterval, UpdateFileDialog.this.notificationBox.isSelected(), (Serializable)chain);
                UpdateFileDialog.this.file.setUpdateInfo(User.getLoggedUser().getLogin(), (long)updateInterval);
            }
        };
        if (task.execute(this.getOwner(), UpdateFileDialog.getString("task.title"), MessageFormat.format(UpdateFileDialog.getString("task.message"), this.file.getName()))) {
            this.stopButton.setEnabled(true);
            StandardDialogs.showInfoDialog((Component)this, (String)MessageFormat.format(UpdateFileDialog.getString("update.start.title"), this.file.getName()), (Object)UpdateFileDialog.getString("update.start.success.message"));
            return true;
        }
        StandardDialogs.showInfoDialog((Component)this, (String)MessageFormat.format(UpdateFileDialog.getString("update.start.title"), this.file.getName()), (Object)UpdateFileDialog.getString("update.start.error.message"));
        return false;
    }

    private boolean handleStopAction() {
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws RemoteException {
                ClientRemoteLocator.projectService.stopUpdate(UpdateFileDialog.this.file.getProjectId(), UpdateFileDialog.this.file.getPath());
                UpdateFileDialog.this.file.setUpdateInfo(null, 0L);
            }
        };
        if (task.execute(this.getOwner(), UpdateFileDialog.getString("task.title"), MessageFormat.format(UpdateFileDialog.getString("task.message"), this.file.getName()))) {
            StandardDialogs.showInfoDialog((Component)this, (String)MessageFormat.format(UpdateFileDialog.getString("update.stop.title"), this.file.getName()), (Object)UpdateFileDialog.getString("update.stop.success.message"));
            this.stopButton.setEnabled(false);
            return true;
        }
        StandardDialogs.showInfoDialog((Component)this, (String)MessageFormat.format(UpdateFileDialog.getString("update.stop.title"), this.file.getName()), (Object)UpdateFileDialog.getString("update.stop.error.message"));
        return false;
    }

    private static String getString(String key) {
        return LNG.get((String)("UpdateFileDialog." + key));
    }
}

