/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.rest.resources.v1.info;

import csbase.client.Client;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import tecgraf.javautils.version.VersionNumber;

@Path(value="v1/info/")
@Api(value="Base", authorizations={@Authorization(value="Bearer", scopes={})})
public class InformationRestService {
    @GET
    @Path(value="version")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get current client version.", notes="This can only be done by the logged in user.", response=VersionWrapper.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Token (Bearer $TOKEN)", dataType="string", required=true, paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=VersionWrapper.class)})
    public Response getVersion() {
        String version = Client.getInstance().getVersion();
        VersionWrapper versionWrapper = new VersionWrapper(version);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)versionWrapper).build();
    }

    public static class VersionWrapper {
        private final VersionNumber versionNumber;

        public String getVersion() {
            return this.versionNumber.toString();
        }

        public int getMajor() {
            return this.versionNumber.getMajor();
        }

        public int getMinor() {
            return this.versionNumber.getMinor();
        }

        public int getPatch() {
            return this.versionNumber.getPatch();
        }

        public VersionWrapper(String versionText) {
            VersionNumber vn = VersionNumber.fromString((String)versionText);
            if (vn == null) {
                vn = VersionNumber.ZERO_VERSION;
            }
            this.versionNumber = vn;
            this.versionNumber.freeze();
        }
    }
}

