/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.rest.resources.v1.project;

import csbase.client.desktop.DesktopFrame;
import csbase.client.rest.resources.v1.application.ApplicationRestService;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import io.jsonwebtoken.impl.Base64Codec;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="v1/project")
@Api(value="Project", authorizations={@Authorization(value="Bearer", scopes={})})
public class ProjectRestService {
    private final Base64Codec codec = new Base64Codec();

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the current project", notes="This can only be done by the logged in user.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Token (Bearer $TOKEN)", dataType="string", required=true, paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ProjectWapper.class), @ApiResponse(code=404, message="No project is open.", response=ApplicationRestService.RESTError.class)})
    public Response getCurrentProject() {
        DesktopFrame desktop = DesktopFrame.getInstance();
        CommonClientProject project = desktop.getProject();
        if (project == null) {
            String jsonMsg = "{\"error\":\"No project found.\"}";
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"{\"error\":\"No project found.\"}").build();
        }
        ProjectWapper projWrapper = new ProjectWapper(project);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)projWrapper).build();
    }

    @POST
    @Path(value="{projectId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Open a project", notes="This can only be done by the logged in user.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Token (Bearer $TOKEN)", dataType="string", required=true, paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ProjectWapper.class), @ApiResponse(code=403, message="Failure while opening the required project", response=ApplicationRestService.RESTError.class), @ApiResponse(code=404, message="The required project cannot be opened.", response=ApplicationRestService.RESTError.class)})
    public Response setCurrentProject(@ApiParam(value="The project Id", required=true) @PathParam(value="projectId") String projectId) {
        String decodedProjectId = this.codec.decodeToString(projectId);
        DesktopFrame desktop = DesktopFrame.getInstance();
        if (!desktop.checkOpenableProject(decodedProjectId)) {
            String fmt = "{\"error\":\"Project %s cannot be opened.\"}";
            String jsonMsg = String.format("{\"error\":\"Project %s cannot be opened.\"}", decodedProjectId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)jsonMsg).build();
        }
        CommonClientProject project = desktop.openProject(decodedProjectId);
        if (project == null) {
            String fmt = "{\"error\":\"Project %s openning failure.\"}";
            String jsonMsg = String.format("{\"error\":\"Project %s openning failure.\"}", decodedProjectId);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)jsonMsg).build();
        }
        ProjectWapper projWrapper = new ProjectWapper(project);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)projWrapper).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @ApiOperation(value="Closes the current project", notes="This can only be done by the logged in user.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Token (Bearer $TOKEN)", dataType="string", required=true, paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ProjectWapper.class), @ApiResponse(code=500, message="Error while closing the current project.", response=ProjectWapper.class)})
    public Response resetCurrentProject() {
        DesktopFrame desktop = DesktopFrame.getInstance();
        CommonClientProject project = desktop.getProject();
        if (project == null) {
            String jsonMsg = "{\"warning\":\"No previous project set.\"}";
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"{\"warning\":\"No previous project set.\"}").build();
        }
        if (!desktop.closeProject()) {
            ProjectWapper projWrapper = new ProjectWapper(project);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)projWrapper).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    public class ProjectWapper {
        private final String id;
        private final String name;
        private final OwnerWrapper owner;

        ProjectWapper(CommonClientProject project) {
            User user;
            this.id = ProjectRestService.this.codec.encode(project.getId().toString());
            this.name = project.getName();
            try {
                user = User.getUser((Object)project.getUserId());
            }
            catch (Exception ex) {
                user = null;
            }
            this.owner = new OwnerWrapper(user);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public OwnerWrapper getOwner() {
            return this.owner;
        }
    }

    public class OwnerWrapper {
        private final String login;
        private final String id;
        private final String name;

        public String getLogin() {
            return this.login;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public OwnerWrapper(User user) {
            if (user == null) {
                this.id = "--";
                this.name = "--";
                this.login = "--";
            } else {
                this.id = user.getId().toString();
                this.name = user.getName();
                this.login = user.getLogin();
            }
        }
    }
}

