/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.charset;

import csbase.client.Client;
import csbase.client.util.charset.CharsetRadioMenuChangeListener;
import csbase.client.util.charset.StandardCharsets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public final class CharsetRadioMenu
extends JMenu {
    List<CharsetRadioMenuChangeListener> listeners = new ArrayList<CharsetRadioMenuChangeListener>();
    private final Map<Charset, JRadioButtonMenuItem> menuItens = new HashMap<Charset, JRadioButtonMenuItem>();

    private final JRadioButtonMenuItem createItem(Charset charset) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem();
        StandardCharsets stdCharsets = StandardCharsets.getInstance();
        String chName = stdCharsets.getLegibleName(charset);
        item.setText(chName);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Charset selectedCharset = CharsetRadioMenu.this.getSelectedCharset();
                CharsetRadioMenu.this.fireListeneners(selectedCharset);
            }
        });
        return item;
    }

    private void fireListeneners(Charset selectedCharset) {
        for (CharsetRadioMenuChangeListener lst : this.listeners) {
            lst.charsetChanged(selectedCharset);
        }
    }

    public CharsetRadioMenu() {
        this(StandardCharsets.getInstance().getAllStandardCharsets());
    }

    public CharsetRadioMenu(List<Charset> charsets) {
        Client client = Client.getInstance();
        Charset sysCharset = client.getSystemDefaultCharset();
        ButtonGroup grp = new ButtonGroup();
        for (Charset ch : charsets) {
            JRadioButtonMenuItem item = this.createItem(ch);
            this.menuItens.put(ch, item);
            if (ch.equals(sysCharset)) {
                item.setSelected(true);
            }
            this.add(item);
            grp.add(item);
        }
    }

    public final void setSelectedCharset(Charset charset) {
        Set<Charset> charsets = this.menuItens.keySet();
        for (Charset ch : charsets) {
            JRadioButtonMenuItem item;
            if (!ch.equals(charset) || (item = this.menuItens.get(ch)) == null) continue;
            item.setSelected(true);
        }
    }

    public final Charset getSelectedCharset() {
        Set<Charset> charsets = this.menuItens.keySet();
        for (Charset ch : charsets) {
            JRadioButtonMenuItem item = this.menuItens.get(ch);
            if (!item.isSelected()) continue;
            return ch;
        }
        return null;
    }

    public final void addCharsetChangeListener(CharsetRadioMenuChangeListener listener) {
        this.listeners.add(listener);
    }

    public final void delCharsetChangeListener(CharsetRadioMenuChangeListener listener) {
        this.listeners.remove(listener);
    }
}

