package csbase.client.applications.algorithmsmanager.actions;

import java.awt.event.ActionEvent;
import java.util.Vector;

import javax.swing.JOptionPane;

import csbase.client.algorithms.tasks.OutdatedFlowInfo;
import csbase.client.algorithms.tasks.OutdatedFlowTask;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmSelectionPanel;
import csbase.client.applications.algorithmsmanager.dialogs.OutdatedFlowDialog;
import csbase.client.desktop.DesktopFrame;

/**
 * Ao que mostra uma lista com os fluxos desatualizados
 *
 *
 * @author Tecgraf/PUC-Rio
 */
public class ListOutdatedAlgorithmAction extends AlgorithmsManagerAction {

  /** Painel de gerncia de categorias que criou essa ao */
  private AlgorithmSelectionPanel selectionPanel;

  /** Dilogo */
  private OutdatedFlowDialog dialog;

  /**
   * Constri a ao
   *
   * @param app A aplicao
   * @param selectionPanel O painel da janela principal
   */
  public ListOutdatedAlgorithmAction(AlgorithmsManager app,
    AlgorithmSelectionPanel selectionPanel) {
    super(app, null);
    this.selectionPanel = selectionPanel;
  }

  /** {@inheritDoc} */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    doAction();
  }

  /**
   * Faz a ao efetivamente
   */
  private void doAction() {
    String resultTitle = getClassString("updating.flows");

    OutdatedFlowTask task = new OutdatedFlowTask();

    ApplicationFrame window = getApplication().getApplicationFrame();
    String title = DesktopFrame.getInstance().getTitle();
    String message = getClassString("searching.outdated.flow");

    try {
      task.execute(window, title, message);
    }
    catch (Exception e) {
      JOptionPane.showMessageDialog(window, getClassString(
        "error.searching.flows"), resultTitle, JOptionPane.PLAIN_MESSAGE);
      return;
    }

    Vector<OutdatedFlowInfo> result = task.getResult();

    if (result.size() <= 0) {
      JOptionPane.showMessageDialog(window, getClassString("all.updated"),
        resultTitle, JOptionPane.PLAIN_MESSAGE);
    }
    else {

      if (dialog == null) {
        dialog = new OutdatedFlowDialog(result, getSelectionPanel());
      }
      else {
        dialog.setData(result, getSelectionPanel());
      }
      dialog.setVisible(true);

    }
  }

  /**
   * Obtm o painel de seleo, onde foi originada essa ao.
   * 
   * @return o painel de seleo, onde foi originada essa ao
   */
  public AlgorithmSelectionPanel getSelectionPanel() {
    return selectionPanel;
  }

  /**
   * Define o painel da janela principal
   * 
   * @param selectionPanel O painel
   */
  public void setSelectionPanel(AlgorithmSelectionPanel selectionPanel) {
    this.selectionPanel = selectionPanel;
    if (dialog != null) {
      dialog.setSelectionPanel(selectionPanel);
    }
  }

  /**
   * Atualiza em funo de um reload
   */
  public void updateToReload() {
    if (dialog != null && dialog.isVisible()) {
      doAction();
    }
  }

}
