package csbase.client.applications.algorithmsmanager.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

import javax.swing.Icon;

import tecgraf.javautils.gui.tree.DefaultNode;
import csbase.client.applications.ApplicationImages;
import csbase.logic.algorithms.Category;

/**
 * Representa um n da rvore de dados. Cada n deve permitir exibir os filhos
 * associados a ele.
 * 
 * 
 */
public final class CategoryTreeNode extends DefaultNode implements
  CategoryNodeInterface, Comparable<CategoryTreeNode> {
  /**
   * O n da rvore.
   */
  private Category node;

  /**
   * Cria o n.
   * 
   * @param node n da rvore (No aceita {@code null})
   */
  public CategoryTreeNode(Category node) {
    super(node.getName());
    this.node = node;
    List<CategoryTreeNode> treeNodes = new ArrayList<>();
    SortedSet<Category> nodes = node.getCategories();
    for (Iterator<Category> iterator = nodes.iterator(); iterator.hasNext();) {
      Category childNode = iterator.next();
      treeNodes.add(new CategoryTreeNode(childNode));
    }
    Collections.sort(treeNodes);

    for (CategoryTreeNode treeNode : treeNodes) {
      addChild(treeNode);
    }
  }

  public int compareTo(CategoryTreeNode node) {
    return getNode().compareTo(node.getNode());
  }

  /**
   * (non-Javadoc)
   * 
   * @see tecgraf.javautils.gui.tree.DefaultNode#getIcon()
   */
  @Override
  public Icon getIcon() {
    return ApplicationImages.ICON_FOLDER_16;
  }

  /**
   * Obtm o n da rvore de dados.
   * 
   * @return o n
   */
  public Category getNode() {
    return node;
  }

  @Override
  public int compare(Category node) {
    return getNode().compareTo(node);
  }

  @Override
  public SortedSet<Category> getSubNodes() {
    return getNode().getCategories();
  }

  @Override
  public String getFullName() {
    return getNode().getFullName();
  }

  @Override
  public String getId() {
    return getNode().getId();
  }

  @Override
  public String getName() {
    return getNode().getName();
  }

  @Override
  public boolean isRootNode() {
    return false;
  }

}
