package csbase.client.applications.algorithmsmanager.report.implementations;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.algorithmsmanager.report.core.AbstractRemoteTest;
import csbase.client.applications.algorithmsmanager.report.core.IResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.ResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.TestStatus;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.Node;
import csbase.remote.ClientRemoteLocator;

/**
 * Testa se existem fluxos desatualizados em um conjunto de algoritmos
 * 
 *
 * @author Tecgraf/PUC-Rio
 */
public class TestOutdatedFlow extends
AbstractRemoteTest<FlowAlgorithmConfigurator> {

  /**
   * Construtor
   *
   * @param window Window para a task
   */
  public TestOutdatedFlow(Window window) {
    super(window, LNG.get("TestOutdatedFlow.task.title"), LNG
      .get("TestOutdatedFlow.task.message"));

  }

  /** {@inheritDoc} */
  @Override
  public List<IResultMessage<FlowAlgorithmConfigurator>> doTest(
    FlowAlgorithmConfigurator configurator) {

    List<IResultMessage<FlowAlgorithmConfigurator>> list = new ArrayList<>();

    list.add(isOutdated(configurator));

    return list;
  }

  /**
   * Responde se um algoritmo est desatualizado
   * 
   * @param configurator O configurador do fluxo
   * @return Se o algoritmo t desatualizado
   */
  private IResultMessage<FlowAlgorithmConfigurator> isOutdated(
    FlowAlgorithmConfigurator configurator) {

    try {

      String messageText = "";

      for (Node node : configurator.getNodes()) {
        String name = node.getConfigurator().getAlgorithmName();
        AlgorithmVersionInfo lastVersion =
          ClientRemoteLocator.algorithmService.getInfo(name).getLastVersion();
        AlgorithmVersionInfo nodeVersion =
          node.getConfigurator().getAlgorithmVersion();
        if (!nodeVersion.equals(lastVersion)) {
          messageText +=
            " |  "
              + LNG.get("TestOutdatedFlow.can.be.updated", new String[] { name,
                  nodeVersion.toString(), lastVersion.toString() });
        }
      }

      if (messageText.length() > 0) {
        messageText = LNG.get("TestOutdatedFlow.outdated") + messageText;
        IResultMessage<FlowAlgorithmConfigurator> message =
          new ResultMessage<>(configurator, TestStatus.ERROR, messageText);
        return message;
      }
      else {
        String text = LNG.get("TestoutdateFlow.uptodate");
        IResultMessage<FlowAlgorithmConfigurator> message =
          new ResultMessage<>(configurator, TestStatus.OK, text);
        return message;

      }
    }
    catch (Exception e) {
      String text = e.getMessage();
      IResultMessage<FlowAlgorithmConfigurator> message =
        new ResultMessage<>(configurator, TestStatus.ERROR, text);
      return message;
    }
  }

  /** {@inheritDoc} */
  @Override
  public String getName() {
    return LNG.get("TestOutdatedFlow.name");
  }

  /** {@inheritDoc} */
  @Override
  public String getDescription() {
    return LNG.get("TestOutdatedFlow.description");
  }

  /** {@inheritDoc} */
  @Override
  public Class<FlowAlgorithmConfigurator> getSubjectClass() {
    return FlowAlgorithmConfigurator.class;
  }

  /** {@inheritDoc} */
  @Override
  public String getSubjectName(FlowAlgorithmConfigurator subject) {
    return subject.getAlgorithmName();
  }

}
