/*
 * $Id: ImageViewerSaveAction.java 110709 2010-09-30 00:30:07Z clinio $
 */
package csbase.client.applications.imageviewer.actions.io;

import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.List;

import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.imageviewer.ImageViewer;
import csbase.client.applications.imageviewer.ImageViewerIO;
import csbase.client.applications.imageviewer.actions.ImageViewerAction;
import csbase.client.util.filechooser.ClientProjectFileChooserUtil;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;

/**
 * Ao de salvar o arquivo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ImageViewerSaveAsAction extends ImageViewerAction {

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public ImageViewerSaveAsAction(ImageViewer application) {
    super(application);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    final ImageViewer application = getApplication();
    final ClientFile currFile = application.getCurrentFile();
    if (currFile == null) {
      return;
    }
    final String currFileType = currFile.getType();
    final List<String> fileTypes = application.getFileTypes();
    final ClientProjectFileChooserUtil.OperationResult result =
      ClientProjectFileChooserUtil
        .browseSingleFileInSaveMode(application, fileTypes, currFileType, false,
          null, true);
    if (result == null) {
      return;
    }

    final ClientProjectFile outFile = result.getClientProjectFile();
    if (outFile == null) {
      return;
    }

    final BufferedImage image = application.getCurrentBufferedImage();
    ImageViewerIO.writeTask(application, image, outFile);
    application.setCurrentFile(outFile);

    final String msg = getString("ImageViewerSaveAsAction.success.msg");
    application.setSaveNeeded(false);
    application.showInformation(msg);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ImageIcon getDefaultIcon() {
    return ApplicationImages.ICON_SAVEAS_16;
  }
}
