package csbase.client.applications.sgamonitor.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import tecgraf.javautils.core.filter.IFilter;
import csbase.logic.SGAInfo;

/**
 * Filtra os ns de um cluster pelo nome.
 * 
 * @author Tecgraf
 */
public class NameFilter implements IFilter<SGAInfo> {

  /**
   * Expresso regular.
   */
  private Pattern pattern;

  /**
   * Construtor padro.
   */
  public NameFilter() {
    // pattern que casa com tudo.
    this.pattern = Pattern.compile("");
  }

  /**
   * Seta o valor da expresso regular.
   * 
   * @param pattern - expresso regular.
   */
  public void setPattern(Pattern pattern) {
    if (pattern != null) {
      this.pattern = pattern;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean accept(SGAInfo obj) {
    Matcher matcher = pattern.matcher(obj.getHostName());
    return matcher.find();
  }
}
