/*
 * DirectorySortNameAction.java
 * 
 * $Author: oikawa $ $Revision: 150777 $ - $Date: 2007-10-08 16:47:07 -0300 (Mon,
 * 08 Oct 2007) $
 */
package csbase.client.project.action;

import java.awt.event.ActionEvent;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeNodeNameComparator;

/**
 * Ao que cria um diretrio.
 */
public class DirectorySortNameAction extends ProjectAction {

  /**
   * {@inheritDoc}
   */
  @Override
  final public void actionPerformed(final ActionEvent e) {
    final ProjectTree tree = getProjectTree();
    tree.setComparator(ProjectTreeNodeNameComparator.getInstance());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public String getName() {
    return LNG.get("PRJ_SORT_DIR_NAME");
  }

  /**
   * Constri a ao.
   * 
   * @param treeView a view
   */
  public DirectorySortNameAction(final ProjectTree treeView) {
    super(treeView);
  }
}
