/*
 * $Id: OpenProjectRemoteTask.java 175519 2016-08-19 18:11:57Z tatimf $
 */
package csbase.client.project.tasks;

import java.awt.Dialog.ModalityType;

import csbase.client.desktop.RemoteTask;
import csbase.logic.CommonClientProject;

/**
 * <p>
 * Tarefa que define a abertura de um projeto no servidor.
 * </p>
 * <p>
 * OBS:  instalado um observador remoto para um projeto aberto.
 * </p>
 * 
 * @author Tecgraf/PUC-Rio
 */
public class OpenProjectRemoteTask extends RemoteTask<CommonClientProject> {
  /** O identificador do projeto a ser aberto. */
  private Object projectId;

  /**
   * Cria uma tarefa para abertura de um projeto no servidor.
   * 
   * @param projectId Identificador do projeto a ser aberto.
   * @param modality tipo de bloqueio das janelas
   */
  public OpenProjectRemoteTask(Object projectId, ModalityType modality) {
    super(modality);
    this.projectId = projectId;
  }

  /**
   * Cria uma tarefa para abertura de um projeto no servidor.
   * 
   * @param projectId Identificador do projeto a ser aberto.
   */
  public OpenProjectRemoteTask(Object projectId) {
    this(projectId, ModalityType.APPLICATION_MODAL);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {
    setResult(openProject());
  }

  /**
   * Abre um projeto no servidor.
   * 
   * @return O projeto aberto, ou null, caso no seja possvel cri-lo.
   * 
   * @throws Exception Caso ocorra algum erro no procedimento.
   */
  protected CommonClientProject openProject() throws Exception {
    return CommonClientProject.openProject(this.projectId, true);
  }
}
