/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import csbase.client.applications.algorithmsmanager.dialogs.VersionDialog;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.AbstractImportFileAction;
import csbase.client.desktop.RemoteTask;
import csbase.client.desktop.Task;
import csbase.client.externalresources.ExternalResources;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.ClientRemoteLocator;
import java.awt.Component;
import java.net.URL;
import java.rmi.RemoteException;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class ImportReleaseNotesFile
extends AbstractImportFileAction {
    private final AlgorithmVersionInfo version;

    public ImportReleaseNotesFile(VersionTree tree, AlgorithmVersionInfo version) {
        super(tree, LNG.get((String)"algomanager.menu.release.notes.add"), 0, false);
        this.version = version;
    }

    @Override
    protected void appletUpload() {
        new UploadReleaseNotesDialog().uploadFile();
    }

    @Override
    protected Task<Boolean> createCheckFileExistenceTask(final String fileName) {
        return new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                AlgorithmInfo algorithm = ImportReleaseNotesFile.this.version.getInfo();
                this.setResult(ClientRemoteLocator.algorithmService.releaseNotesFileExists((Object)algorithm.getId(), (Object)ImportReleaseNotesFile.this.version.getId(), fileName));
            }
        };
    }

    @Override
    protected RemoteFileChannelInfo prepareUpload(String fileName, boolean isZipLocalFile) throws RemoteException {
        AlgorithmInfo algorithm = this.version.getInfo();
        return ClientRemoteLocator.algorithmService.prepareUploadReleaseNotesFile((Object)algorithm.getId(), (Object)this.version.getId(), fileName, isZipLocalFile);
    }

    private class UploadReleaseNotesDialog
    extends VersionDialog {
        private Object versionId;

        public UploadReleaseNotesDialog() {
            super(ImportReleaseNotesFile.this.version.getInfo());
        }

        public void uploadFile() {
            String algoId = this.algoInfo.getId();
            if (ExternalResources.getInstance().isEnabled()) {
                String addr = AlgorithmManagementProxy.retrieveReleaseNotesUploadURL(algoId, this.versionId, ImportReleaseNotesFile.this.getWindow());
                if (addr == null) {
                    return;
                }
                try {
                    URL url = new URL(addr);
                    ExternalResources.getInstance().showDocument(url);
                }
                catch (Exception ex) {
                    StandardErrorDialogs.showErrorDialog(ImportReleaseNotesFile.this.getWindow(), this.dialogTitle, LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_IO_ERROR"), ex);
                }
            } else {
                StandardDialogs.showInfoDialog((Component)ImportReleaseNotesFile.this.getWindow(), (String)this.dialogTitle, (Object)LNG.get((String)"algomanager.error.upload_not_available"));
            }
        }
    }
}

