/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.multiflow;

import csbase.client.applications.Application;
import csbase.client.applications.flowapplication.multiflow.AbstractMultipleFlowConfigurationDialog;
import csbase.client.util.csvpanel.columns.ClientFileChooserTextPanel;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientFileChooserType;
import csbase.logic.ClientFile;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import tecgraf.javautils.gui.GBC;

public class ExportMultipleFlowConfigurationDialog
extends AbstractMultipleFlowConfigurationDialog {
    private JTextField executionNumberField;
    private JCheckBox previewCSV;
    private ClientFileChooserTextPanel chooserPanel;

    public ExportMultipleFlowConfigurationDialog(Application application, ClientFile file) {
        super(application, file);
    }

    public ExportMultipleFlowConfigurationDialog(Application application) {
        super(application);
    }

    @Override
    protected JPanel createMainComponent() {
        JPanel contentPanel = new JPanel(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder(1);
        contentPanel.setBorder(border);
        GBC gbc = new GBC().insets(5, 5, 5, 5).west().weighty(1.0);
        JLabel executionNumberLabel = new JLabel(this.getString("ExportMultipleFlowConfigurationDialog.numExecsLabel"));
        contentPanel.add((Component)executionNumberLabel, gbc);
        this.executionNumberField = new JTextField(2);
        contentPanel.add((Component)this.executionNumberField, new GBC(gbc).gridx(1).pushx());
        JLabel configurationFileLabel = new JLabel(this.getString("ExportMultipleFlowConfigurationDialog.configFileLabel"));
        contentPanel.add((Component)configurationFileLabel, new GBC(gbc).gridy(1));
        this.chooserPanel = new ClientFileChooserTextPanel(this, "MFLX", ClientFileChooserType.SAVE, ClientFileChooserSelectionMode.FILES_ONLY, ClientFileChooserTextPanel.ClientFileLocation.ANY);
        contentPanel.add((Component)this.chooserPanel, new GBC(gbc).gridy(1).gridx(1));
        this.previewCSV = new JCheckBox(this.getString("ExportMultipleFlowConfigurationDialog.previewCSVLabel"), true);
        contentPanel.add((Component)this.previewCSV, new GBC(gbc).gridy(3).width(2));
        return contentPanel;
    }

    public boolean showPreview() {
        return this.previewCSV.isSelected();
    }

    public Integer getExecutionNumber() {
        if (this.isConfirmed() && this.validateExecutionNumber()) {
            return this.extractExecutionNumber();
        }
        return null;
    }

    @Override
    protected boolean validateFields() {
        this.setConfigurationFile(this.chooserPanel.getSelectedFile());
        return this.validateExecutionNumber() && super.validateFields();
    }

    private boolean validateExecutionNumber() {
        Integer numExecs = this.extractExecutionNumber();
        if (numExecs == null || numExecs <= 0) {
            ((Application)this.getApplication()).showError(this.getString("ExportMultipleFlowConfigurationDialog.invalidNumExecsError", new Object[]{numExecs}));
            return false;
        }
        return true;
    }

    private Integer extractExecutionNumber() {
        String text = this.executionNumberField.getText();
        try {
            Integer numExecs = Integer.valueOf(text);
            return numExecs;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

