package csbase.client.algorithms.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import csbase.client.desktop.RemoteTask;
import csbase.logic.algorithms.AlgorithmConfigurator.ConfiguratorType;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.Node;
import csbase.remote.ClientRemoteLocator;

public class OutdatedFlowTask extends RemoteTask<Vector<OutdatedFlowInfo>> {

  @Override
  protected void performTask() throws Exception {
    Vector<OutdatedFlowInfo> outdated = new Vector<OutdatedFlowInfo>();
    AlgorithmInfo infos[] = ClientRemoteLocator.algorithmService.getAllInfo();

    for (AlgorithmInfo info : infos) {
      OutdatedFlowInfo outInfo = isOutdated(info);
      if (outInfo != null) {
        outdated.add(outInfo);
      }
    }
    setResult(outdated);
  }

  /**
   * Responde se um algoritmo est desatualizado
   * 
   * @param info O algoritmo
   * @return Se o algoritmo t desatualizado
   */
  protected OutdatedFlowInfo isOutdated(AlgorithmInfo info) {

    AlgorithmVersionInfo version = info.getLastVersion();
    if (version == null) {
      return null;
    }
    if (version.getType() == ConfiguratorType.SIMPLE) {
      return null;
    }

    try {

      FlowAlgorithmConfigurator configurator =
        (FlowAlgorithmConfigurator) ClientRemoteLocator.algorithmService
          .createAlgorithmConfigurator(info.getName(), version.getId());

      List<AlgorithmInfo> lastVersionNodes = new ArrayList<AlgorithmInfo>();
      List<AlgorithmVersionInfo> outdatedVersionNodes =
        new ArrayList<AlgorithmVersionInfo>();

      for (Node node : configurator.getNodes()) {
        String name = node.getConfigurator().getAlgorithmName();
        AlgorithmVersionInfo lastVersion = ClientRemoteLocator.algorithmService
          .getInfo(name).getLastVersion();
        AlgorithmVersionInfo nodeVersion = node.getConfigurator()
          .getAlgorithmVersion();
        if (!nodeVersion.equals(lastVersion)) {
          lastVersionNodes.add(ClientRemoteLocator.algorithmService.getInfo(
            name));
          outdatedVersionNodes.add(nodeVersion);
        }
      }

      if (lastVersionNodes.size() > 0) {
        OutdatedFlowInfo outInfo = new OutdatedFlowInfo(info, lastVersionNodes,
          outdatedVersionNodes, null);
        return outInfo;
      }
      return null;

    }
    catch (Exception e) {
      OutdatedFlowInfo outInfo = new OutdatedFlowInfo(info, null, null, e);
      return outInfo;
    }
  }
}
