/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.dal.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Set;

import tecgraf.javautils.xml.XMLReader;
import csbase.client.applications.commandsmonitor.dal.ICommandsTableDAO;
import csbase.client.applications.commandsmonitor.dal.ITablesTabDAO;
import csbase.client.applications.commandsmonitor.models.ColumnDTO;
import csbase.client.applications.commandsmonitor.models.CommandsFilterDTO;
import csbase.client.applications.commandsmonitor.models.CommandsTableDTO;
import csbase.client.applications.commandsmonitor.models.TabbedPaneDTO;
import csbase.client.applications.commandsmonitor.models.TablesTabDTO;

public class XmlConfigDAO implements ICommandsTableDAO, ITablesTabDAO {

  private Set<ColumnDTO> _columnsInfo;
  private Set<CommandsFilterDTO> _filtersInfo;
  private Set<CommandsTableDTO> _tablesInfo;
  private TabbedPaneDTO _tabsConfig;

  public XmlConfigDAO(Reader reader) throws IOException {
    this(reader, "UTF-8");
  }

  public XmlConfigDAO(Reader reader, String encoding) throws IOException {

    XMLReader xml_reader =
      new XMLReader(reader, new ConfigXMLHandler(), false, this);
    xml_reader.setEncoding(encoding);
    xml_reader.read();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Set<ColumnDTO> getColumnsInfo() {
    return _columnsInfo;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Set<CommandsFilterDTO> getFiltersInfo() {
    return _filtersInfo;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Set<CommandsTableDTO> getTablesInfo() {
    return _tablesInfo;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<TablesTabDTO> getTabsInfo() {
    return _tabsConfig.getTabsInfo();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getSelectedTabId() {
    return _tabsConfig.getSelectedTabId();
  }

  public void setColumnsInfo(Set<ColumnDTO> columnsInfo) {
    _columnsInfo = columnsInfo;
  }

  public void setFiltersInfo(Set<CommandsFilterDTO> filtersInfo) {
    _filtersInfo = filtersInfo;
  }

  public void setTablesInfo(Set<CommandsTableDTO> tablesInfo) {
    _tablesInfo = tablesInfo;
  }

  public void setTabsConfig(TabbedPaneDTO tabsConfig) {
    _tabsConfig = tabsConfig;
  }
}
