package csbase.client.applications.flowapplication;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

import com.kitfox.svg.app.beans.SVGIcon;

import tecgraf.vix.VO;

/**
 * 
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class SVGVO extends VO {

  /**
   * Possveis valores para alinhamento vertical da imagem.
   */
  public enum VerticalAlignment {
    /**
     * Alinhamento inferior.
     */
    BOTTOM,
    /**
     * Alinhamento superior.
     */
    TOP,
    /**
     * Alinhamento central.
     */
    CENTER;
  }

  /**
   * Possveis valores para alinhamento horizontal da imagem.
   */
  public enum HorizontalAlignment {
    /**
     * Alinhamento  esquerda
     */
    LEFT,
    /**
     * Alinhamento  direita.
     */
    RIGHT,
    /**
     * Alinhamento central.
     */
    CENTER;
  }

  /**
   * Espaamento padro da imagem.
   */
  private static final int DEFAULT_PADDING = 2;

  /**
   * Espaamento abaixo da imagem.
   */
  private double bottomPadding;
  /**
   * Espaamento  esquerda da imagem.
   */
  private double leftPadding;

  /**
   * Espaamento  direita da imagem.
   */
  private double rightPadding;

  /**
   * Espaamento acima da imagem.
   */
  private double topPadding;

  /**
   * Imagem svg a ser mostrada no VO
   */
  private SVGIcon icon;

  /**
   * Retngulo que representa o tamanho da imagem (dentro do espao disponvel).
   */
  final private Rectangle2D.Double rectangle = new Rectangle2D.Double();

  /**
   * Retngulo que representa o espao disponvel para desenhar a imagem.
   */
  final private Rectangle2D.Double internalRectangle = new Rectangle2D.Double();

  /**
   * Alinhamento vertical da imagem dentro do retngulo disponvel para desenho.
   */
  private VerticalAlignment vAlign = VerticalAlignment.CENTER;

  /**
   * Alinhamento horizontal da imagem dentro do retngulo disponvel para
   * desenho.
   */
  private HorizontalAlignment hAlign = HorizontalAlignment.CENTER;

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object arg0) {
    if (!SVGVO.class.isInstance(arg0)) {
      return false;
    }
    SVGVO other = (SVGVO) arg0;
    if (this.icon.getSvgURI().equals(other.icon.getSvgURI())) {
      return true;
    }
    return false;
  }

  /**
   * Construtor.
   * 
   * @param image imagem svg a ser mostrada no VO.
   */
  public SVGVO(SVGIcon image) {

    this.icon = new SVGIcon();
    this.icon.setSvgURI(image.getSvgURI());

    this.icon.setScaleToFit(true);
    this.icon.setAntiAlias(true);

    int ih = icon.getIconHeight();
    int iw = icon.getIconWidth();

    if (ih <= 0 || iw <= 0) {
      this.icon = null;
      ih = 32;
      iw = 32;
      final String err = String.format("icon with bad sizes: %d x %d", iw, ih);
      System.out.println(err);
    }

    this.bottomPadding = DEFAULT_PADDING;
    this.leftPadding = DEFAULT_PADDING;
    this.rightPadding = DEFAULT_PADDING;
    this.topPadding = DEFAULT_PADDING;

    final Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, iw, ih);
    setRectangle(rect);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void callbackRepaint(Graphics2D g) {
    if (icon == null) {
      g.setColor(Color.red);
      g.draw(rectangle);
      return;
    }
    // DEBUG    
    //    g.setColor(Color.blue);
    //    g.draw(rectangle);
    //
    //    g.setColor(Color.green);
    //    g.draw(internalRectangle);
    //
    //    g.setColor(Color.red);
    //    g.draw(getBounds2D());

    if (rectangle.width > 0 && rectangle.height > 0 && rectangle.x > 0
      && rectangle.y > 0) {
      final double shiftX = rectangle.width / 2.0;
      final double shiftY = rectangle.height / 2.0;
      final int x = (int) Math.round(rectangle.getCenterX() - shiftX);
      final int y = (int) Math.round(rectangle.getCenterY() - shiftY);
      final int width = (int) Math.round(rectangle.width);
      final int height = (int) Math.round(rectangle.height);
      icon.setPreferredSize(new Dimension(width, height));
      icon.paintIcon(null, g, x, y);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Rectangle2D getBounds2D() {
    final Rectangle2D.Double rect = new Rectangle2D.Double();
    rect.setRect(rectangle.getX() - this.leftPadding, rectangle.getY()
      - this.topPadding, rectangle.getWidth() + this.rightPadding
        + this.leftPadding, rectangle.getHeight() + this.bottomPadding
          + this.topPadding);
    return rect;
  }

  /**
   * Atribui o tamanho do retngulo da imagem.
   * 
   * @param rect o retngulo.
   */
  public void setRectangle(Rectangle2D.Double rect) {
    internalRectangle.setRect(rect.x + this.leftPadding, rect.y
      + this.topPadding, rect.width - this.rightPadding - this.leftPadding,
      rect.height - this.bottomPadding - this.topPadding);

    final int ih = icon.getIconHeight();
    final int iw = icon.getIconWidth();
    final double ir = ((double) iw) / ih;

    final double rh = internalRectangle.getHeight();
    final double rw = internalRectangle.getWidth();
    final double rr = (rw / rh);

    final double newH;
    final double newW;
    if (rr < 1.0) {
      newW = rw;
      if (ir < 1.0) {
        newH = rw / ir;
      }
      else {
        newH = newW / ir;
      }
    }
    else {
      newH = rh;
      if (ir < 1.0) {
        newW = rh * ir;
      }
      else {
        newW = newH * ir;
      }
    }

    final double x, y;
    switch (vAlign) {
      case BOTTOM: {
        y = internalRectangle.getY() + rh - newH;
      }
        break;
      case TOP:
        y = internalRectangle.getY();
        break;
      case CENTER:
      default: {
        y = internalRectangle.getCenterY() - newH / 2.0;
      }
    }

    switch (hAlign) {
      case LEFT: {
        x = internalRectangle.getX();
      }
        break;
      case RIGHT:
        x = internalRectangle.getX() + rw - newW;
        break;
      case CENTER:
      default: {
        x = internalRectangle.getCenterX() - newW / 2.0;
      }
    }
    rectangle.setRect(x, y, newW, newH);
  }

  /**
   * Obtm a altura do retngulo.
   * 
   * @return a altura do retngulo.
   */
  public double getHeight() {
    return rectangle.getHeight() + this.bottomPadding + this.topPadding;
  }

  /**
   * Obtm a largura do retngulo.
   * 
   * @return a largura do retngulo.
   */
  public double getWidth() {
    return rectangle.getWidth() + this.leftPadding + this.rightPadding;
  }

  /**
   * Retorna o tipo de alinhamento vertical do cone em relao ao espao
   * disponvel para o desenho.
   * 
   * @return vAlign O alinhamento vertical.
   */
  public VerticalAlignment getVerticalAlignment() {
    return vAlign;
  }

  /**
   * Atribui o tipo de alinhamento vertical do cone em relao ao espao
   * disponvel para o desenho.
   * 
   * @param vAlign O alinhamento vertical.
   */
  public void setVerticalAlignment(VerticalAlignment vAlign) {
    this.vAlign = vAlign;
  }

  /**
   * Retorna o tipo de alinhamento horizontal do cone em relao ao espao
   * disponvel para o desenho.
   * 
   * @return hAlign O alinhamento horizontal.
   */
  public HorizontalAlignment getHorizontalAlignment() {
    return hAlign;
  }

  /**
   * Atribui o tipo de alinhamento horizontal do cone em relao ao espao
   * disponvel para o desenho.
   * 
   * @param hAlign O alinhamento horizontal.
   */
  public void setHorizontalAlignment(HorizontalAlignment hAlign) {
    this.hAlign = hAlign;
  }

  /**
   * Obtm o espaamento  esquerda da imagem.
   * 
   * @return o espaamento  esquerda.
   */
  public double getLeftPadding() {
    return this.leftPadding;
  }

  /**
   * Obtm o espaamento  direita da imagem.
   * 
   * @return o espaamento  direita.
   */
  public double getRightPadding() {
    return this.rightPadding;
  }

  /**
   * Obtm o espaamento acima da imagem.
   * 
   * @return o espaamento acima.
   */
  public double getTopPadding() {
    return this.topPadding;
  }

  /**
   * Atribui o espaamento abaixo da imagem.
   * 
   * @param bottomPadding o espaamento abaixo.
   */
  public void setBottomPadding(final double bottomPadding) {
    this.bottomPadding = bottomPadding;
  }

  /**
   * Atribui o espaamento  esquerda da imagem.
   * 
   * @param leftPadding o espaamento  esquerda.
   */
  public void setLeftPadding(final double leftPadding) {
    this.leftPadding = leftPadding;
  }

  /**
   * Atribui o espaamento  direita da imagem.
   * 
   * @param rightPadding o espaamento  direita.
   */
  public void setRightPadding(final double rightPadding) {
    this.rightPadding = rightPadding;
  }

  /**
   * Atribui o espaamento acima da imagem.
   * 
   * @param topPadding o espaamento acima.
   */
  public void setTopPadding(final double topPadding) {
    this.topPadding = topPadding;
  }

}