/*
 * $Id$
 */
package csbase.client.util.gui.log.actions;

import javax.swing.Action;
import javax.swing.JComponent;

import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.actions.core.AbstractLogAction;
import csbase.client.util.gui.log.enums.FontType;

/**
 * Define o tipo da fonte sendo utilizada na rea de texto.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class SetFontTypeAction extends AbstractLogAction {

  /**
   * Tipo da fonte
   */
  private FontType type;

  /**
   * Construtor
   * 
   * @param logPanel o painel de log
   * @param type tipo da fonte a ser ajustado
   */
  public SetFontTypeAction(final LogPanel logPanel, final FontType type) {
    super(logPanel);
    this.type = type;
    final String name = type.getLabel();
    putValue(Action.NAME, name);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) throws Exception {
    getLogPanel().getTextArea().setFontType(type);
  }
}