/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.report.core;

import csbase.client.applications.algorithmsmanager.report.core.ITest;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tecgraf.javautils.gui.GBC;

public class TestSelectionPanel
extends JPanel {
    List<ItemListener> listeners = new ArrayList<ItemListener>();
    private final List<TestCheckbox> checkBoxes = new ArrayList<TestCheckbox>();

    TestSelectionPanel(List<ITest<?>> tests) {
        JPanel checkBoxPanel = new JPanel(new GridBagLayout());
        int y = 0;
        int x = 0;
        for (ITest<?> test : tests) {
            TestCheckbox testCheckBox = new TestCheckbox(test);
            this.checkBoxes.add(testCheckBox);
            testCheckBox.checkBox.setSelected(true);
            testCheckBox.checkBox.addItemListener(e -> this.callListeners(e));
            checkBoxPanel.add((Component)testCheckBox.checkBox, new GBC(x, y).insets(3, 0, 0, 0).horizontal());
            y += x;
            x = (x + 1) % 2;
        }
        JScrollPane scroll = new JScrollPane(checkBoxPanel);
        scroll.setBorder(null);
        this.setLayout(new GridBagLayout());
        this.add((Component)scroll, new GBC(0, 0).both().center().insets(0, 0, 0, 0));
    }

    private void callListeners(ItemEvent e) {
        this.listeners.forEach(l -> l.itemStateChanged(e));
    }

    public List<ITest<?>> getSelection() {
        List<ITest<?>> tests = this.checkBoxes.stream().filter(c -> c.checkBox.isSelected()).map(c -> c.test).collect(Collectors.toList());
        return tests;
    }

    public void addItemListener(ItemListener l) {
        this.listeners.add(l);
    }

    public void removeItemListener(ItemListener l) {
        this.listeners.remove(l);
    }

    static class TestCheckbox {
        public JCheckBox checkBox;
        public ITest<?> test;

        public TestCheckbox(ITest<?> test) {
            this.checkBox = new JCheckBox(test.getName());
            this.test = test;
        }
    }
}

