/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransferclient;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.logic.User;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferElement;
import csbase.logic.filetransferservice.FileTransferPredefinedConnection;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.FileTransferServiceInterface;
import java.util.ArrayList;
import java.util.List;

public class FileTransferProxy {
    private final FileTransferClient application;

    public boolean checkConnection(final FileTransferConnection connection) {
        final FileTransferServiceInterface service = this.getService();
        if (service == null) {
            return false;
        }
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                boolean check = service.checkConnection(connection);
                this.setResult(check);
            }

            @Override
            protected void handleError(Exception error) {
                this.setResult(false);
            }
        };
        ApplicationFrame frame = this.application.getApplicationFrame();
        String userName = connection.getUserName();
        String serverName = connection.getServerName();
        String connectionText = userName + "@" + serverName;
        task.execute(frame, "", connectionText);
        Exception exception = task.getError();
        if (exception != null) {
            return false;
        }
        if (task.wasCancelled()) {
            return false;
        }
        Boolean result = (Boolean)task.getResult();
        return result;
    }

    public static FileTransferServiceInterface getFileTransferService() {
        FileTransferServiceInterface service = ClientRemoteLocator.fileTransferService;
        return service;
    }

    private FileTransferServiceInterface getService() {
        FileTransferServiceInterface service = FileTransferProxy.getFileTransferService();
        if (service == null) {
            String tag = "no.service.found.msg";
            String prefix = this.getClass().getSimpleName();
            String err = this.application.getString(prefix + "." + "no.service.found.msg");
            this.application.showError(err);
            return null;
        }
        return service;
    }

    public void download(final FileTransferConnection connection, final String remotePath, final String[] localPath, final long size) {
        final FileTransferServiceInterface service = this.getService();
        if (service == null) {
            return;
        }
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                service.download(connection, remotePath, localPath, size);
            }
        };
        ApplicationFrame frame = this.application.getApplicationFrame();
        task.execute(frame, "", "\u2190 " + remotePath);
    }

    public void upload(final FileTransferConnection connection, final String remotePath, final String[] localPath, final long size) {
        final FileTransferServiceInterface service = this.getService();
        if (service == null) {
            return;
        }
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                service.upload(connection, remotePath, localPath, size);
            }
        };
        ApplicationFrame frame = this.application.getApplicationFrame();
        task.execute(frame, "", "\u2192 " + remotePath);
    }

    public List<FileTransferElement> listContent(final FileTransferConnection connection, final String remoteDirPath) {
        final FileTransferServiceInterface service = this.getService();
        if (service == null) {
            return new ArrayList<FileTransferElement>();
        }
        RemoteTask<List<FileTransferElement>> task = new RemoteTask<List<FileTransferElement>>(){

            protected void performTask() throws Exception {
                List list = service.listContent(connection, remoteDirPath);
                this.setResult(list);
            }
        };
        ApplicationFrame frame = this.application.getApplicationFrame();
        task.execute(frame, "", remoteDirPath);
        Exception exception = task.getError();
        if (exception != null) {
            return new ArrayList<FileTransferElement>();
        }
        List result = (List)task.getResult();
        return result;
    }

    public FileTransferProxy(FileTransferClient application) {
        this.application = application;
    }

    public final List<FileTransferRequest> getAllRequests(final User user) {
        final FileTransferServiceInterface service = this.getService();
        if (service == null) {
            return new ArrayList<FileTransferRequest>();
        }
        RemoteTask<List<FileTransferRequest>> task = new RemoteTask<List<FileTransferRequest>>(){

            protected void performTask() throws Exception {
                List list = service.getAllRequests(user);
                this.setResult(list);
            }
        };
        task.setProgressDialogDelay(10);
        ApplicationFrame frame = this.application.getApplicationFrame();
        String userName = user != null ? user.getName() : "-";
        task.execute(frame, "", userName);
        Exception exception = task.getError();
        if (exception != null) {
            return new ArrayList<FileTransferRequest>();
        }
        List result = (List)task.getResult();
        return result;
    }

    public void interruptRequests(final List<String> requests) {
        final FileTransferServiceInterface service = this.getService();
        if (service == null) {
            return;
        }
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                service.interruptRequest(requests);
            }
        };
        ApplicationFrame frame = this.application.getApplicationFrame();
        task.execute(frame, "", "XX");
        Exception exception = task.getError();
        if (exception != null) {
            return;
        }
    }

    public void removeRequests(final List<String> requests) {
        final FileTransferServiceInterface service = this.getService();
        if (service == null) {
            return;
        }
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                service.removeRequest(requests);
            }
        };
        ApplicationFrame frame = this.application.getApplicationFrame();
        task.execute(frame, "", "---");
        Exception exception = task.getError();
        if (exception != null) {
            return;
        }
    }

    public static String getServerName() {
        String serverName = null;
        RemoteTask<String> task = new RemoteTask<String>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.server.getSystemName());
            }
        };
        task.setProgressDialogDelay(10);
        task.execute(DesktopFrame.getInstance().getDesktopFrame(), "", "... ...");
        if (!task.getStatus()) {
            serverName = "ERROR";
        }
        if ((serverName = (String)task.getResult()) == null) {
            serverName = "NULL";
        }
        return serverName;
    }

    public List<FileTransferPredefinedConnection> getPedefinedConnections() {
        final FileTransferServiceInterface service = this.getService();
        if (service == null) {
            return new ArrayList<FileTransferPredefinedConnection>();
        }
        RemoteTask<List<FileTransferPredefinedConnection>> task = new RemoteTask<List<FileTransferPredefinedConnection>>(){

            protected void performTask() throws Exception {
                this.setResult(service.getPredefinedConnections());
            }
        };
        ApplicationFrame frame = this.application.getApplicationFrame();
        task.execute(frame, "", "---");
        Exception exception = task.getError();
        if (exception != null) {
            return null;
        }
        return (List)task.getResult();
    }
}

