/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.openbus;

import csbase.client.openbus.OpenBusAccessPoint;
import csbase.client.openbus.OpenBusEventReceiverInterface;
import java.util.List;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import scs.core.ComponentContext;
import tecgraf.openbus.session_service.v1_05.SessionEvent;
import tecgraf.openbus.session_service.v1_05.SessionEventSinkPOA;

public final class OpenBusEventSink
extends SessionEventSinkPOA {
    private final ComponentContext context;

    private boolean isValueString(Any value) {
        try {
            value.extract_string();
            return true;
        }
        catch (BAD_OPERATION e) {
            return false;
        }
    }

    private boolean isValueBoolean(Any value) {
        try {
            value.extract_boolean();
            return true;
        }
        catch (BAD_OPERATION e) {
            return false;
        }
    }

    public final void disconnect(String memberIdentifier) {
    }

    private boolean loopReceiveOnNoValue(List<OpenBusEventReceiverInterface> receivers, String sourceId, String destId, String type) {
        for (OpenBusEventReceiverInterface receiver : receivers) {
            boolean treated = receiver.receiveEventWithNoValue(sourceId, destId, type);
            receiver.logReceivedEvent(treated, sourceId, destId, type, null);
            if (!treated) continue;
            return true;
        }
        return false;
    }

    private boolean loopReceiveOnStringValue(List<OpenBusEventReceiverInterface> receivers, String sourceId, String destId, String type, String stringValue) {
        for (OpenBusEventReceiverInterface receiver : receivers) {
            boolean treated = receiver.receiveEventWithStringValue(sourceId, destId, type, stringValue);
            receiver.logReceivedEvent(treated, sourceId, destId, type, stringValue);
            if (!treated) continue;
            return true;
        }
        return false;
    }

    private boolean loopReceiveOnBooleanValue(List<OpenBusEventReceiverInterface> receivers, String sourceId, String destId, String type, boolean booleanValue) {
        for (OpenBusEventReceiverInterface receiver : receivers) {
            boolean treated = receiver.receiveEventWithBooleanValue(sourceId, destId, type, booleanValue);
            receiver.logReceivedEvent(treated, sourceId, destId, type, booleanValue);
            if (!treated) continue;
            return true;
        }
        return false;
    }

    public final void push(String memberIdentifier, SessionEvent event) {
        Object value;
        boolean treated;
        OpenBusAccessPoint oap = OpenBusAccessPoint.getInstance();
        List<OpenBusEventReceiverInterface> receivers = oap.getSession().getEventReceivers();
        String rawType = event.type.trim();
        String[] pathData = oap.getSession().extractPathTypeData(rawType);
        String sourceId = pathData[0];
        String destId = pathData[1];
        String type = pathData[2];
        Any anyValue = event.value;
        if (anyValue == null) {
            treated = false;
            value = "null any!!!";
        } else if (this.isValueString(anyValue)) {
            String stringValue = anyValue.extract_string().trim();
            treated = this.loopReceiveOnStringValue(receivers, sourceId, destId, type, stringValue);
            value = stringValue;
        } else if (this.isValueBoolean(anyValue)) {
            boolean booleanValue = anyValue.extract_boolean();
            treated = this.loopReceiveOnBooleanValue(receivers, sourceId, destId, type, booleanValue);
            value = booleanValue;
        } else {
            treated = this.loopReceiveOnNoValue(receivers, sourceId, destId, type);
            value = null;
        }
        oap.getSession().signalEventReceived(treated, sourceId, destId, type, value);
    }

    public OpenBusEventSink() {
        this.context = null;
    }

    public OpenBusEventSink(ComponentContext context) {
        this.context = context;
    }

    public final ComponentContext getContext() {
        return this.context;
    }
}

