/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree;

import csbase.client.applications.algorithmsmanager.versiontree.AbstractVersionTreeNode;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.ITransferableSource;
import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.ITransferableTarget;
import csbase.client.project.ClientProjectFileType;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.ClientAlgorithmFile;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractFileInfoNode
extends AbstractVersionTreeNode
implements ITransferableSource,
ITransferableTarget,
Serializable {
    private static final transient ImageIcon FILE_ICON = ClientProjectFileType.getFileType("UNKNOWN").getBaseIcon();
    private static final transient ImageIcon DIRECTORY_ICON = ClientProjectFileType.getFileType("DIRECTORY_TYPE").getBaseIcon();
    private final AlgorithmVersionInfo version;
    private final FileInfo file;
    private final IChildrenFactory childrenFactory;
    private final boolean executable;

    protected AbstractFileInfoNode(VersionTree tree, AlgorithmVersionInfo version, FileInfo file, IChildrenFactory childrenFactory, boolean executable) {
        super(tree, file.getName());
        this.version = version;
        this.file = file;
        this.childrenFactory = childrenFactory;
        this.executable = executable;
        for (FileInfo childFile : file.getChildren()) {
            this.addChild(childFile);
        }
    }

    public final AlgorithmVersionInfo getVersion() {
        return this.version;
    }

    public final FileInfo getFile() {
        return this.file;
    }

    @Override
    public final boolean allowMultipleSelection(AbstractVersionTreeNode other) {
        return null != this.getParent() && this.getParent().equals(other.getParent());
    }

    @Override
    public final int compareTo(MutableTreeNode node) {
        if (node instanceof AbstractFileInfoNode) {
            AbstractFileInfoNode fileNode = (AbstractFileInfoNode)node;
            if (this.file.isDirectory() && !fileNode.file.isDirectory()) {
                return -1;
            }
            if (!this.file.isDirectory() && fileNode.file.isDirectory()) {
                return 1;
            }
        }
        return super.compareTo(node);
    }

    @Override
    public final ImageIcon getImageIcon() {
        return this.file.isDirectory() ? DIRECTORY_ICON : FILE_ICON;
    }

    @Override
    public final boolean canImport(Object[] data, DataFlavor flavor) {
        return this.getFile().isDirectory() && null != data && 0 < data.length && this.getDataFlavor().equals(flavor);
    }

    @Override
    public final boolean importData(Object[] data) {
        DataTransferObject dto = (DataTransferObject)data[0];
        AlgorithmVersionInfo sourceVersion = dto.getVersion();
        ArrayList<FileInfo> files = new ArrayList<FileInfo>(data.length);
        for (Object obj : data) {
            dto = (DataTransferObject)obj;
            FileInfo fileInfo = dto.getFile();
            files.add(fileInfo);
        }
        IPathFactory sourcePathFactory = this.createSourcePathFactory(dto);
        IPathFactory targetPathFactory = this.createTargetPathFactory();
        AlgorithmManagementProxy.copyFiles(sourceVersion, files, sourcePathFactory, this.getVersion(), this.getFile(), targetPathFactory, this.executable, this.getWindow());
        return true;
    }

    @Override
    public final Serializable getData() {
        return this.createDataTransferObject();
    }

    protected final void addChild(FileInfo childFile) {
        this.add(this.childrenFactory.createNode(childFile));
    }

    public abstract ClientAlgorithmFile.AlgorithmFileType getType();

    protected abstract IPathFactory createTargetPathFactory();

    protected abstract IPathFactory createSourcePathFactory(DataTransferObject var1);

    protected DataTransferObject createDataTransferObject() {
        return new DataTransferObject(this);
    }

    protected FileInfo[] getSelectedFiles() {
        TreePath[] paths = this.getTree().getSelectionPaths();
        if (null == paths) {
            return new FileInfo[0];
        }
        FileInfo[] files = new FileInfo[paths.length];
        for (int inx = 0; inx < paths.length; ++inx) {
            TreePath path = paths[inx];
            Object component = path.getLastPathComponent();
            if (!this.getClass().isAssignableFrom(component.getClass())) {
                return new FileInfo[0];
            }
            AbstractFileInfoNode node = (AbstractFileInfoNode)component;
            files[inx] = node.getFile();
        }
        return files;
    }

    public static class DataTransferObject
    implements Serializable {
        private final AlgorithmVersionInfo version;
        private final FileInfo file;

        public DataTransferObject(AbstractFileInfoNode node) {
            this.version = node.getVersion();
            this.file = node.getFile();
        }

        public AlgorithmVersionInfo getVersion() {
            return this.version;
        }

        public FileInfo getFile() {
            return this.file;
        }
    }

    protected static interface IChildrenFactory {
        public AbstractFileInfoNode createNode(FileInfo var1);
    }
}

