/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.algorithmsmanager.versiontree.AbstractVersionTreeNode;
import csbase.client.applications.algorithmsmanager.versiontree.ExecutableFileNode;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.ImportExecutableFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.PasteFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.RemovePlatform;
import csbase.client.applications.algorithmsmanager.versiontree.actions.VersionWarningActionDecorator;
import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.ITransferableTarget;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutablePathFactory;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import tecgraf.javautils.core.lng.LNG;

final class PlatformNode
extends AbstractVersionTreeNode
implements ITransferableTarget {
    private final AlgorithmVersionInfo version;

    public PlatformNode(VersionTree tree, AlgorithmVersionInfo version, String platform) {
        super(tree, platform);
        this.version = version;
        List files = (List)version.getPlatforms().get(platform);
        for (FileInfo file : files) {
            this.add(new ExecutableFileNode(tree, version, platform, file));
        }
    }

    @Override
    public ImageIcon getImageIcon() {
        return ApplicationImages.ICON_FOLDER_16;
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new ImportExecutableFile(this.getTree(), this.version, this.getPlatformName()))));
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new PasteFile(this.getTree(), LNG.get((String)"algomanager.menu.bin_file.paste"), ExecutableFileNode.DATA_FLAVOR))));
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new RemovePlatform(this.getTree(), this.version, this.getPlatformName()))));
        return popupMenu;
    }

    private String getPlatformName() {
        return this.getUserObject().toString();
    }

    @Override
    public boolean canImport(Object[] data, DataFlavor flavor) {
        return null != data && 0 < data.length && ExecutableFileNode.DATA_FLAVOR.equals(flavor);
    }

    @Override
    public boolean importData(Object[] data) {
        ExecutableFileNode.ExecutableDTO dto = (ExecutableFileNode.ExecutableDTO)data[0];
        AlgorithmVersionInfo sourceVersion = dto.getVersion();
        String sourcePlatform = dto.getPlatformName();
        ArrayList<FileInfo> files = new ArrayList<FileInfo>(data.length);
        for (Object obj : data) {
            dto = (ExecutableFileNode.ExecutableDTO)obj;
            FileInfo file = dto.getFile();
            files.add(file);
        }
        ExecutablePathFactory sourcePathFactory = new ExecutablePathFactory(sourceVersion, sourcePlatform);
        ExecutablePathFactory targetPathFactory = new ExecutablePathFactory(this.version, this.getPlatformName());
        AlgorithmManagementProxy.copyFiles(sourceVersion, files, (IPathFactory)sourcePathFactory, this.version, null, (IPathFactory)targetPathFactory, true, this.getWindow());
        return true;
    }
}

