/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectPermissions;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class AppendUsersTask
extends ProjectsManagerTask<Void> {
    private final List<ProjectsManagerData> projects;
    private final Set<Object> userIds;
    private final boolean readOnly;

    public AppendUsersTask(ProjectsManager projectsManager, List<ProjectsManagerData> projects, Set<Object> userIds, boolean readOnly) {
        super(projectsManager);
        this.projects = projects;
        this.userIds = userIds;
        this.readOnly = readOnly;
    }

    protected void performTask() throws Exception {
        if (this.userIds == null) {
            return;
        }
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        if (this.readOnly) {
            for (ProjectsManagerData pmd : this.projects) {
                CommonClientProject ccp = psi.openProject(pmd.getProjectId(), false);
                ccp.setSharingType(ProjectPermissions.SharingType.PARTIAL);
                HashSet<Object> newUserIds = new HashSet<Object>();
                newUserIds.addAll(this.userIds);
                Set usersRO = ccp.getUsersRO();
                if (usersRO != null) {
                    newUserIds.addAll(usersRO);
                    ccp.updateUsersRO(newUserIds);
                }
                ccp.close(true);
            }
        } else {
            for (ProjectsManagerData pmd : this.projects) {
                CommonClientProject ccp = psi.openProject(pmd.getProjectId(), false);
                ccp.setSharingType(ProjectPermissions.SharingType.PARTIAL);
                HashSet<Object> newUserIds = new HashSet<Object>();
                newUserIds.addAll(this.userIds);
                Set usersRW = ccp.getUsersRW();
                if (usersRW != null) {
                    newUserIds.addAll(ccp.getUsersRW());
                    ccp.updateUsersRW(newUserIds);
                }
                ccp.close(true);
            }
        }
    }
}

