/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.dialogs;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.dialogs.core.ProjectsManagerDialog;
import csbase.client.applications.projectsmanager.models.ProjectGeneralAreaOccupationData;
import csbase.client.applications.projectsmanager.proxy.GetGeneralSpaceUsageTask;
import csbase.logic.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.Rotation;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class ProjectAreaOccupationDialog
extends ProjectsManagerDialog {
    private final JFreeChart graph;
    private final JTextField freeDiskSpaceField = new JTextField();
    private final JTextField occupiedDiskSpaceField = new JTextField();
    private final JButton refreshButton = new JButton();
    private final JButton closeButton = new JButton();
    private final JLabel occupiedDiskSpaceLabel = new JLabel(ProjectsManagerUI.getString("ProjectAreaOccupationDialog.occupied.space.label"));

    private void buildMainPanel() {
        ChartPanel chartPanel = new ChartPanel(this.graph);
        chartPanel.setPopupMenu(null);
        BorderUtil.setLowBorder((JComponent)chartPanel);
        JLabel freeDiskSpaceLabel = new JLabel(ProjectsManagerUI.getString("ProjectAreaOccupationDialog.free.space.label"));
        JComponent[][] textComps = new JComponent[][]{{freeDiskSpaceLabel, this.freeDiskSpaceField}, {this.occupiedDiskSpaceLabel, this.occupiedDiskSpaceField}};
        JPanel textPanel = GUIUtils.createBasicGridPanel((JComponent[][])textComps);
        BorderUtil.setLinedBorder((JComponent)textPanel);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.refreshButton);
        buttonsPanel.add(this.closeButton);
        this.setLayout(new GridBagLayout());
        this.add((Component)textPanel, new GBC(0, 0).horizontal());
        this.add((Component)chartPanel, new GBC(0, 1).both());
        this.add((Component)buttonsPanel, new GBC(0, 2).horizontal());
    }

    private void initGeneralComponents() {
        this.freeDiskSpaceField.setEditable(false);
        this.occupiedDiskSpaceField.setEditable(false);
        this.freeDiskSpaceField.setHorizontalAlignment(4);
        this.occupiedDiskSpaceField.setHorizontalAlignment(4);
        this.refreshButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectAreaOccupationDialog.this.refreshData();
            }
        });
        this.refreshButton.setText(ProjectsManagerUI.getString("ProjectAreaOccupationDialog.refresh.button"));
        final ProjectAreaOccupationDialog pod = this;
        this.closeButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pod.dispose();
            }
        });
        this.closeButton.setText(ProjectsManagerUI.getString("ProjectAreaOccupationDialog.close.button"));
        JComponent[] buttons = new JComponent[]{this.refreshButton, this.closeButton};
        GUIUtils.matchPreferredSizes((JComponent[])buttons);
    }

    private final void refreshData() {
        ProjectsManager projectsManager = this.getProjectsManager();
        GetGeneralSpaceUsageTask ggsut = new GetGeneralSpaceUsageTask(projectsManager);
        ApplicationFrame appFrame = projectsManager.getApplicationFrame();
        String msg = this.getString("ProjectAreaOccupationDialog.task.message");
        ggsut.execute(appFrame, projectsManager.getName(), msg);
        if (ggsut.wasCancelled()) {
            String err = this.getString("ProjectAreaOccupationDialog.task.cancelled.message");
            ggsut.showError(err);
            return;
        }
        if (!ggsut.getStatus()) {
            Exception exception = ggsut.getError();
            projectsManager.showError(this, exception.getMessage());
            return;
        }
        ProjectGeneralAreaOccupationData paod = (ProjectGeneralAreaOccupationData)ggsut.getResult();
        this.updateFields(paod);
        this.updateChart(paod);
    }

    private void updateChart(ProjectGeneralAreaOccupationData paod) {
        double free;
        double used;
        PiePlot pieplot = (PiePlot)this.graph.getPlot();
        if (paod == null) {
            used = 0.0;
            free = 0.0;
        } else {
            free = paod.getFreeSpace();
            used = paod.getOccupiedSpace();
        }
        if (free < 0.0 || used < 0.0) {
            used = 0.0;
            free = 0.0;
        }
        this.graph.setTitle(this.getString("ProjectAreaOccupationDialog.chart.title"));
        ArrayList<TextTitle> subtitles = new ArrayList<TextTitle>();
        String timeText = Utilities.getFormattedDate((long)new Date().getTime());
        subtitles.add(new TextTitle(timeText));
        this.graph.setSubtitles(subtitles);
        pieplot.setNoDataMessage(this.getString("ProjectAreaOccupationDialog.failed.error"));
        String freeStr = this.getString("ProjectAreaOccupationDialog.free.legend");
        String usedStr = this.getString("ProjectAreaOccupationDialog.used.legend");
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)freeStr), free);
        dataset.setValue((Comparable)((Object)usedStr), used);
        pieplot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} : {2}"));
        pieplot.setSectionPaint((Comparable)((Object)freeStr), (Paint)new Color(150, 255, 150));
        pieplot.setSectionPaint((Comparable)((Object)usedStr), (Paint)new Color(255, 150, 150));
        pieplot.setDirection(Rotation.CLOCKWISE);
        pieplot.setBackgroundPaint(null);
        pieplot.setOutlinePaint(null);
        pieplot.setCircular(true);
        pieplot.setDataset((PieDataset)dataset);
    }

    private final void updateFields(ProjectGeneralAreaOccupationData paod) {
        if (paod == null) {
            String invText = this.getString("ProjectAreaOccupationDialog.invalid.text");
            this.freeDiskSpaceField.setText(invText);
            this.occupiedDiskSpaceField.setText(invText);
        } else {
            double freeSpace = paod.getFreeSpace();
            String str1 = ProjectsManagerUI.generateSizeStringFromDouble(freeSpace);
            this.freeDiskSpaceField.setText(str1);
            double occupiedSpace = paod.getOccupiedSpace();
            String str2 = ProjectsManagerUI.generateSizeStringFromDouble(occupiedSpace);
            this.occupiedDiskSpaceField.setText(str2);
        }
    }

    public ProjectAreaOccupationDialog(ProjectsManager projectsManager) {
        super(projectsManager);
        String title = projectsManager.getName();
        this.graph = ChartFactory.createPieChart((String)title, null, (boolean)true, (boolean)false, (boolean)false);
        this.initGeneralComponents();
        this.buildMainPanel();
        this.refreshData();
    }
}

