/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.serverdiagnostic.monitor;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.serverdiagnostic.monitor.SwingRenderer;
import csbase.client.applications.serverdiagnostic.monitor.ValidationStatusListCellRenderer;
import csbase.logic.diagnosticservice.ResourceProperty;
import csbase.logic.diagnosticservice.Status;
import csbase.logic.diagnosticservice.StatusCode;
import csbase.logic.diagnosticservice.ValidationStatus;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import tecgraf.javautils.gui.GBC;

public class DefaultSwingRenderer
implements SwingRenderer {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    @Override
    public JComponent getHeadline(Status status) {
        JLabel headline = new JLabel(status.getResourceName());
        headline.setIcon(this.getIcon(status.getCode()));
        headline.setToolTipText("[" + this.dateFormat.format(status.getTimestamp()) + "] " + status);
        return headline;
    }

    @Override
    public JComponent getDetails(Status status) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel paramTableLabel = new JLabel(this.getString("DefaultSwingRenderer.parameters.label"));
        panel.add((Component)paramTableLabel, new GBC(0, 0).horizontal().northwest().insets(0, 0, 5, 0));
        panel.add((Component)new JScrollPane(this.getParamTable(status)), new GBC(0, 1).both().northwest().insets(0, 0, 5, 0));
        JLabel validationStatusListLabel = new JLabel(this.getString("DefaultSwingRenderer.validations.label"));
        paramTableLabel.setHorizontalTextPosition(2);
        panel.add((Component)validationStatusListLabel, new GBC(0, 2).none().northwest().insets(5, 0, 5, 0));
        panel.add((Component)new JScrollPane(this.getValidationStatusList(status)), new GBC(0, 3).both().northwest().insets(0, 0, 5, 0));
        return panel;
    }

    protected JComponent getValidationStatusList(Status status) {
        DefaultListModel<ValidationStatus> validationStatusListModel = new DefaultListModel<ValidationStatus>();
        for (ValidationStatus validationStatus : status.getValidationStatusList()) {
            validationStatusListModel.addElement(validationStatus);
        }
        JList<Object> validationStatusList = new JList<Object>(validationStatusListModel);
        validationStatusList.setCellRenderer(new ValidationStatusListCellRenderer());
        return validationStatusList;
    }

    protected Icon getIcon(StatusCode code) {
        switch (code) {
            case OK: {
                return ApplicationImages.GREEN_BALL_16;
            }
            case WARNING: {
                return ApplicationImages.YELLOW_BALL_16;
            }
            case ERROR: 
            case UNAVAILABLE: 
            case INITIATING: {
                return ApplicationImages.RED_BALL_16;
            }
        }
        return null;
    }

    private JComponent getParamTable(Status status) {
        Object[][] data = this.getParameters(status);
        JTable paramTable = new JTable(data, new String[]{this.getString("DefaultSwingRenderer.name.label"), this.getString("DefaultSwingRenderer.value.label"), this.getString("DefaultSwingRenderer.source.label")});
        paramTable.setAutoResizeMode(4);
        paramTable.setEnabled(false);
        return paramTable;
    }

    private Object[][] getParameters(Status status) {
        List props = status.getProperties();
        if (props == null) {
            return new Object[0][0];
        }
        Object[][] data = new Object[props.size()][];
        int i = 0;
        for (ResourceProperty p : props) {
            data[i++] = new Object[]{p.name, p.value, p.source};
        }
        return data;
    }

    protected String getString(String key) {
        return ApplicationManager.getInstance().getApplicationRegistry("serverdiagnostic").getString(key);
    }
}

