/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.AbstractVersionTreeNodeAction;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class RemoveConfigurationFiles
extends AbstractVersionTreeNodeAction {
    private final AlgorithmVersionInfo version;
    private final FileInfo[] files;

    public RemoveConfigurationFiles(VersionTree tree, AlgorithmVersionInfo version, FileInfo[] files) {
        super(tree, LNG.get((String)"algomanager.menu.config.remove"));
        this.version = version;
        this.files = files;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new RemoveConfiguratorDialog().show();
    }

    private class RemoveConfiguratorDialog {
        private RemoveConfiguratorDialog() {
        }

        public void show() {
            String dialogTitle = LNG.get((String)"algomanager.title.config.management");
            Object[] options = new Object[]{LNG.get((String)"algomanager.button.remove"), LNG.get((String)"algomanager.button.cancel")};
            int opt = StandardDialogs.showOptionDialog((Component)RemoveConfigurationFiles.this.getWindow(), (String)dialogTitle, (Object)MessageFormat.format(LNG.get((String)"algomanager.msg.confirm.configurator_remove"), FormatUtils.format((Object[])RemoveConfigurationFiles.this.files)), (Object[])options);
            if (opt != 0) {
                return;
            }
            boolean success = AlgorithmManagementProxy.removeConfigurationFiles(RemoveConfigurationFiles.this.version, RemoveConfigurationFiles.this.files, RemoveConfigurationFiles.this.getWindow());
            if (!success) {
                StandardErrorDialogs.showErrorDialog(RemoveConfigurationFiles.this.getWindow(), LNG.get((String)"algomanager.title.error") + " - " + dialogTitle, LNG.get((String)"algomanager.error.configurator_remove"));
            }
        }
    }
}

