/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.diskinfo;

import csbase.client.applications.Application;
import csbase.client.applications.diskinfo.DiskUserTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import tecgraf.javautils.gui.GBC;

public class DiskUserTableFrame
extends JFrame {
    public DiskUserTableFrame(Application app, Hashtable<Object, Double> usersData) {
        super(app.getString("tableFrame.title"));
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getTablePanel(app, usersData));
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiskUserTableFrame.this.close();
            }
        });
    }

    public void showFrame() {
        this.setLocationRelativeTo(null);
        this.pack();
        this.setVisible(true);
    }

    private JPanel getTablePanel(Application app, Hashtable<Object, Double> usersData) {
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.setOpaque(true);
        GBC gbc = new GBC(0, 0).northwest().insets(10, 10, 0, 10);
        JLabel orderHintLabel = new JLabel(app.getString("tableFrame.orderHint"));
        tablePanel.add((Component)orderHintLabel, gbc);
        JTable table = new JTable(new DiskUserTableModel(app, usersData));
        table.setPreferredScrollableViewportSize(new Dimension(500, 200));
        table.setFillsViewportHeight(true);
        table.setAutoCreateRowSorter(true);
        for (int i = 0; i < table.getModel().getColumnCount(); ++i) {
            table.getColumn(table.getModel().getColumnName(i)).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (column > 0) {
                        DecimalFormat formatter = new DecimalFormat("##0.##");
                        value = formatter.format(value);
                    }
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (isSelected) {
                        c.setBackground(table.getSelectionBackground());
                    } else {
                        c.setBackground(row % 2 == 0 ? Color.white : Color.LIGHT_GRAY);
                    }
                    c.setForeground(table.getForeground());
                    return c;
                }
            });
        }
        JScrollPane scrollPane = new JScrollPane(table);
        gbc = new GBC(0, 1).northwest().insets(10, 10, 0, 10).both();
        tablePanel.add((Component)scrollPane, gbc);
        JButton closeButton = new JButton(app.getString("tableFrame.close"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiskUserTableFrame.this.close();
            }
        });
        gbc = new GBC(0, 2).center().insets(10, 10, 10, 0);
        tablePanel.add((Component)closeButton, gbc);
        return tablePanel;
    }

    private void close() {
        this.dispose();
        this.setVisible(false);
    }
}

