/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransferclient.panels.queuepanel;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.filetransferclient.FileTransferClientUI;
import csbase.client.util.DateTranslator;
import csbase.logic.User;
import csbase.logic.filetransferservice.FileTransferRequestStatus;
import csbase.logic.filetransferservice.FileTransferRequestType;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import tecgraf.javautils.core.lng.FormatUtils;

class QueueRenderer
implements TableCellRenderer {
    public static final DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();

    private String dateToString(long date) {
        if (date < 0L) {
            return "-";
        }
        DateTranslator dateTranslator = DateTranslator.getInstance();
        String formDate = dateTranslator.translate(new Date(date));
        return formDate;
    }

    private String rateToString(double rate) {
        if (rate < 0.0) {
            return "-";
        }
        String text = String.format("%.1f kb/s", rate);
        return text;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component renderer = DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        JLabel label = (JLabel)renderer;
        label.setOpaque(true);
        label.setIcon(null);
        label.setHorizontalAlignment(2);
        label.setForeground(Color.black);
        label.setToolTipText(null);
        if (column == 0) {
            FileTransferRequestStatus status = (FileTransferRequestStatus)value;
            label.setHorizontalAlignment(0);
            Icon icon = FileTransferClientUI.getStatusIcon(status);
            label.setIcon(icon);
            label.setText(null);
            label.setToolTipText(FileTransferClientUI.getStatusTooltip(status));
        } else if (column == 1) {
            label.setHorizontalAlignment(0);
            FileTransferRequestType type = (FileTransferRequestType)value;
            Icon icon = FileTransferClientUI.getTypeIcon(type);
            label.setIcon(icon);
            label.setText(null);
            label.setToolTipText(FileTransferClientUI.getTypeTooltip(type));
        } else if (column == 2) {
            if (value == null) {
                label.setText("???");
            } else {
                User user = (User)value;
                label.setText(user.getLogin() + " - " + user.getName());
            }
        } else {
            if (column == 3) {
                double perc = (Double)value;
                if (perc < 0.0) {
                    label.setHorizontalAlignment(0);
                    label.setText("???");
                    return label;
                }
                JProgressBar prog = new JProgressBar();
                prog.setStringPainted(true);
                prog.setMinimum(0);
                prog.setMaximum(100);
                prog.setValue((int)Math.round(perc));
                prog.setString(String.format("%.1f %%", perc));
                return prog;
            }
            if (column == 4) {
                String path = (String)value;
                label.setHorizontalAlignment(2);
                label.setText(path);
            } else if (column == 5) {
                long size = (Long)value;
                if (size < 0L) {
                    label.setHorizontalAlignment(0);
                } else {
                    label.setHorizontalAlignment(4);
                }
                ApplicationManager mgr = ApplicationManager.getInstance();
                label.setText(FormatUtils.formatSize((long)size, (int)2, (Locale)mgr.getLocale()));
            } else if (column == 6) {
                double rate = (Double)value;
                label.setHorizontalAlignment(4);
                label.setText(this.rateToString(rate));
            } else if (column == 7) {
                long qTime = (Long)value;
                label.setHorizontalAlignment(0);
                label.setText(this.dateToString(qTime));
            } else if (column == 8) {
                long sTime = (Long)value;
                label.setHorizontalAlignment(0);
                label.setText(this.dateToString(sTime));
            } else if (column == 9) {
                long eTime = (Long)value;
                label.setHorizontalAlignment(0);
                label.setText(this.dateToString(eTime));
            } else if (column == 10) {
                String err = (String)value;
                label.setHorizontalAlignment(2);
                if (err != null) {
                    label.setText(err);
                    label.setForeground(Color.RED);
                } else {
                    label.setText("-");
                }
            }
        }
        return label;
    }
}

