/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.filters;

import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.messages.CheckClipboardFlavorMessage;
import csbase.client.applications.flowapplication.messages.ClipboardIsEmptyMessage;
import csbase.client.applications.flowapplication.messages.CopyMessage;
import csbase.client.applications.flowapplication.messages.PasteMessage;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import tecgraf.vix.TypeMessage;

public final class CopyAndPasteFilter
extends WorkspaceFilter
implements ClipboardOwner {
    private final Clipboard clipboard;

    public CopyAndPasteFilter(Clipboard clipboard, Workspace workspace) {
        super(workspace);
        if (clipboard == null) {
            throw new IllegalArgumentException("O par\u00e2metro clipboard est\u00e1 nulo.");
        }
        this.clipboard = clipboard;
    }

    @Override
    public void lostOwnership(Clipboard clpbrd, Transferable contents) {
    }

    public boolean msgHandlerVS(TypeMessage message) {
        if (message instanceof CopyMessage) {
            this.handleCopyMessage((CopyMessage)message);
            return true;
        }
        if (message instanceof PasteMessage) {
            this.handlePasteMessage((PasteMessage)message);
            return true;
        }
        if (message instanceof ClipboardIsEmptyMessage) {
            this.handleClipboardIsEmptyMessage((ClipboardIsEmptyMessage)message);
            return true;
        }
        if (message instanceof CheckClipboardFlavorMessage) {
            this.handleCheckClipboardFlavorMessage((CheckClipboardFlavorMessage)message);
            return true;
        }
        return super.msgHandlerVS(message);
    }

    private void handleCheckClipboardFlavorMessage(CheckClipboardFlavorMessage message) {
        Transferable contents = this.clipboard.getContents(this);
        if (contents != null) {
            DataFlavor flavor = message.getFlavor();
            boolean isFlavorSupported = contents.isDataFlavorSupported(flavor);
            message.setSupportsDataFlavor(isFlavorSupported);
        } else {
            message.setSupportsDataFlavor(false);
        }
    }

    private void handleClipboardIsEmptyMessage(ClipboardIsEmptyMessage message) {
        message.setClipboradIsEmpty(this.clipboard.getContents(this) != null);
    }

    private void handleCopyMessage(CopyMessage message) {
        this.clipboard.setContents(message.getTransferable(), this);
    }

    private void handlePasteMessage(PasteMessage message) {
        message.setTransferable(this.clipboard.getContents(this));
    }
}

