/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph;

import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElementListener;
import csbase.client.applications.flowapplication.messages.PickElementMessage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JToolTip;
import tecgraf.vix.Group;
import tecgraf.vix.TypeMessage;
import tecgraf.vix.TypeVO;
import tecgraf.vix.TypeVS;

public abstract class GraphElement
extends Group {
    protected static final Color HIGHT_LIGHT_COLOR = new Color(59, 193, 255);
    private int id;
    private boolean isSelected;
    private final List<GraphElementListener> listenerList;
    private JToolTip toolTip;

    protected GraphElement(Graph graph, int id) {
        this.setGraph(graph);
        this.listenerList = new LinkedList<GraphElementListener>();
        this.id = id;
    }

    public abstract String getHint(Point2D var1);

    public abstract boolean turnOnHighlight(Point2D var1);

    public abstract void turnOffHighlight();

    public void attach() {
        this.getGraph().addElement(this);
    }

    public void callbackRepaint(Graphics2D g) {
        super.callbackRepaint(g);
        if (this.toolTip != null) {
            this.toolTip.setVisible(true);
        }
    }

    public void deattach() {
        this.getGraph().removeElement(this);
    }

    public Graphics2D getGraphics2D() {
        if (this.getVS() == null) {
            return null;
        }
        return this.getVS().getGraphics2D();
    }

    public boolean msgHandlerVO(TypeMessage msg) {
        if (super.msgHandlerVO(msg)) {
            return true;
        }
        if (msg instanceof PickElementMessage) {
            return this.handlePickElementMessage((PickElementMessage)msg);
        }
        return false;
    }

    public void removeAllListeners() {
        this.listenerList.clear();
    }

    public void setSelected(boolean isSelected) {
        if (this.isSelected() != isSelected) {
            this.isSelected = isSelected;
            this.notifySelecionChanged();
        }
    }

    public final void addListener(GraphElementListener listener) {
        this.listenerList.add(listener);
    }

    public final boolean drag(Point2D startPoint, Point2D endPoint) {
        if (this.isSelected() && this.doDrag(startPoint, endPoint)) {
            for (GraphElementListener listener : this.listenerList) {
                listener.wasDragged(this, startPoint, endPoint);
            }
            return true;
        }
        return false;
    }

    public void bringToFront() {
        this.getGraph().bringToFront(this);
    }

    public final boolean drag(double tx, double ty) {
        if (this.isSelected()) {
            this.doDrag(tx, ty);
            for (GraphElementListener listener : this.listenerList) {
                listener.wasDragged(this, tx, ty);
            }
            return true;
        }
        return false;
    }

    public final boolean drop(Point2D pt) {
        if (this.isSelected()) {
            this.doDrop(pt);
            for (GraphElementListener listener : this.listenerList) {
                listener.wasDropped(this, pt);
            }
            return true;
        }
        return false;
    }

    public final boolean drop() {
        if (this.isSelected()) {
            this.doDrop(this.getCenterPoint());
            for (GraphElementListener listener : this.listenerList) {
                listener.wasDropped(this, this.getCenterPoint());
            }
            return true;
        }
        return false;
    }

    public final Graph getGraph() {
        return (Graph)this.getVS();
    }

    public void setId(int id) {
        Graph graph = this.getGraph();
        if (!graph.isIdAvailable(id)) {
            throw new IllegalArgumentException("Element id already taken: " + id);
        }
        this.id = id;
    }

    public final int getId() {
        return this.id;
    }

    public final boolean isSelected() {
        return this.isSelected;
    }

    public final TypeVO pick(Point2D pt) {
        Object aVo = super.pick(pt);
        if (aVo == null && this.contains(pt)) {
            aVo = this;
        }
        return aVo;
    }

    public final void removeListener(GraphElementListener listener) {
        this.listenerList.remove(listener);
    }

    public final void repaint() {
        if (this.getVS() != null) {
            super.repaint();
        }
    }

    protected abstract boolean contains(Point2D var1);

    protected abstract boolean doDrag(Point2D var1, Point2D var2);

    protected abstract void doDrag(double var1, double var3);

    protected abstract void doDrop(Point2D var1);

    protected abstract void translate(Point2D var1);

    protected void reset() {
        if (this.toolTip != null) {
            this.toolTip = null;
        }
        this.setSelected(false);
        this.turnOffHighlight();
    }

    protected final List<GraphElementListener> getListenerList() {
        return Collections.unmodifiableList(this.listenerList);
    }

    private Point2D getCenterPoint() {
        Rectangle2D bounds = this.getBounds2D();
        double centerX = bounds.getCenterX();
        double centerY = bounds.getCenterY();
        return new Point2D.Double(centerX, centerY);
    }

    private boolean handlePickElementMessage(PickElementMessage message) {
        if (this.contains(message.getPoint())) {
            message.setElement(this);
            return true;
        }
        return false;
    }

    private void notifySelecionChanged() {
        for (GraphElementListener listener : this.listenerList) {
            listener.wasSelected(this);
        }
    }

    private void setGraph(Graph graph) {
        this.changeVS(null, (TypeVS)graph);
    }
}

