/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.UserRemovalFromProjectTask;
import csbase.logic.ProjectPermissions;
import csbase.logic.User;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import tecgraf.javautils.gui.StandardDialogs;

public class UserRemovalFromProjectAction
extends ProjectsManagerAction {
    public UserRemovalFromProjectAction(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public void actionDone() throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> projectList = projectsManager.getSelectedProjects();
        if (projectList == null || projectList.size() <= 0) {
            return;
        }
        List<ProjectsManagerData> projects = this.validateProjects(projectList);
        if (projects == null) {
            return;
        }
        boolean ret = this.runTask(projects);
        if (ret) {
            projectsManager.refreshProjectsTable();
        } else {
            StandardDialogs.showWarningDialog((Component)projectsManager.getApplicationFrame(), (String)this.getString("UserRemovalFromProjectAction.shared.user.removal.error.title"), (String)this.getString("UserRemovalFromProjectAction.shared.user.removal.error.message"));
        }
    }

    private boolean runTask(List<ProjectsManagerData> projects) throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        ApplicationFrame frame = projectsManager.getApplicationFrame();
        UserRemovalFromProjectTask urfp = new UserRemovalFromProjectTask(this.getProjectsManager(), projects);
        urfp.execute(frame, this.getString("UserRemovalFromProjectAction.title"), this.getString("UserRemovalFromProjectAction.message"));
        if (urfp.wasCancelled()) {
            String err = this.getString("UserRemovalFromProjectAction.cancelled.message");
            urfp.showError(err);
            return false;
        }
        if (!urfp.getStatus()) {
            Exception exception = urfp.getError();
            throw exception;
        }
        return (Boolean)urfp.getResult();
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return ApplicationImages.ICON_CANCEL_16;
    }

    @Override
    protected List<ProjectsManagerData> validateProjects(List<ProjectsManagerData> projectList) {
        String someDeniedMessage;
        int res;
        ArrayList<ProjectsManagerData> prjList = new ArrayList<ProjectsManagerData>();
        prjList.addAll(projectList);
        ArrayList<ProjectsManagerData> failedProjects = new ArrayList<ProjectsManagerData>();
        User loggedUser = User.getLoggedUser();
        Object loggedUserId = loggedUser.getId();
        int i = 0;
        while (i < prjList.size()) {
            boolean hasWriteAccess;
            ProjectsManagerData pmd = (ProjectsManagerData)prjList.get(i);
            ProjectSpaceAllocation spaceAllocation = pmd.getProjectSpaceAllocation();
            ProjectPermissions.SharingType sharingType = pmd.getSharingType();
            Set<Object> usersRW = pmd.getUsersRW();
            boolean isAdmin = loggedUser.isAdmin();
            boolean isOwner = pmd.getOwnerId().equals(loggedUserId);
            boolean bl = hasWriteAccess = sharingType == ProjectPermissions.SharingType.PARTIAL && usersRW.contains(loggedUserId);
            if (spaceAllocation.isOpenable() && !isAdmin && !isOwner && hasWriteAccess) {
                ++i;
                continue;
            }
            failedProjects.add(pmd);
            prjList.remove(i);
        }
        ProjectsManager projectsManager = this.getProjectsManager();
        if (prjList.size() == 0) {
            String deniedMessage = this.getString("UserRemovalFromProjectAction.project.selection.denied.message") + this.getString("UserRemovalFromProjectAction.project.requirements.message");
            StatusDialog.showNoneOkDialog(projectsManager, deniedMessage, failedProjects, this.getString("UserRemovalFromProjectAction.project.selection.failure.message"));
            return null;
        }
        if (failedProjects.size() > 0 && (res = StatusDialog.showSomeOkDialog(projectsManager, someDeniedMessage = this.getString("UserRemovalFromProjectAction.project.selection.some.denied.message") + this.getString("UserRemovalFromProjectAction.project.requirements.message"), prjList, this.getString("UserRemovalFromProjectAction.project.selection.some.failure.message"))) == 0) {
            return null;
        }
        return prjList;
    }
}

