/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.panels;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.panels.ProjectsManagerPanel;
import csbase.client.applications.projectsmanager.panels.renderers.ProjectListCellRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GBC;

public class ProjectSharingInfoPanel
extends ProjectsManagerPanel {
    private List<ProjectsManagerData> projectsManagerData;
    private final boolean displayOwner;
    private final boolean showTitledBorder;

    public ProjectSharingInfoPanel(ProjectsManager projectsManager, List<ProjectsManagerData> projectsManagerData, boolean displayOwner) {
        this(projectsManager, projectsManagerData, displayOwner, true);
    }

    public ProjectSharingInfoPanel(ProjectsManager projectsManager, List<ProjectsManagerData> projectsManagerData, boolean displayOwner, boolean showTitledBorder) {
        super(projectsManager);
        this.projectsManagerData = projectsManagerData;
        this.displayOwner = displayOwner;
        this.showTitledBorder = showTitledBorder;
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        DefaultListModel<ProjectsManagerData> listModel = new DefaultListModel<ProjectsManagerData>();
        for (ProjectsManagerData pmd : this.projectsManagerData) {
            listModel.addElement(pmd);
        }
        JList list = new JList(listModel);
        list.setCellRenderer(new ProjectListCellRenderer(this.displayOwner));
        list.setVisibleRowCount(4);
        list.setVisible(true);
        list.setEnabled(true);
        list.validate();
        JScrollPane listScrollPane = new JScrollPane(list);
        listScrollPane.setMinimumSize(new Dimension(400, 65));
        listScrollPane.setVerticalScrollBarPolicy(22);
        JPanel listPanel = new JPanel(new GridBagLayout());
        if (this.showTitledBorder) {
            BorderUtil.setTitledBorder((JComponent)listPanel, (String)this.getString("ProjectSharingInfoPanel.projects.text"));
        }
        GBC gbc = new GBC(1, 0).horizontal().northwest();
        this.add((Component)listScrollPane, gbc);
    }
}

