/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.serverdiagnostic.basic;

import csbase.client.applications.ApplicationComponentPanel;
import csbase.client.applications.serverdiagnostic.ServerDiagnostic;
import csbase.logic.diagnosticservice.ServerBasicInfo;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.gui.GBC;

public class IdentificationInfoPanel
extends ApplicationComponentPanel<ServerDiagnostic> {
    private ServerBasicInfo basicInfo;

    public IdentificationInfoPanel(ServerDiagnostic application, ServerBasicInfo basicInfo) {
        super(application);
        this.basicInfo = basicInfo;
        this.buildInterface();
    }

    private void buildInterface() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.buildSystemPanel(), new GBC(0, 0).horizontal().northwest().insets(0, 0, 5, 0));
        this.add((Component)this.buildHostPanel(), new GBC(0, 1).horizontal().northwest().insets(0, 0, 5, 0));
        this.add((Component)this.buildJVMPanel(), new GBC(0, 2).horizontal().northwest().insets(0, 0, 5, 0));
        this.add((Component)this.buildRepositoriesPanel(), new GBC(0, 3).both().northwest().insets(0, 0, 0, 0));
        this.add((Component)this.buildLibsPanel(), new GBC(1, 0).both().northwest().insets(0, 0, 0, 0).height(4));
    }

    private JPanel buildSystemPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.getString("label.system.name")), new GBC(0, 0).none().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(this.basicInfo.systemName), new GBC(1, 0).horizontal().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(this.getString("label.system.version")), new GBC(0, 1).none().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(this.basicInfo.systemVersion), new GBC(1, 1).horizontal().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(this.getString("label.system.date")), new GBC(0, 2).none().northwest().insets(0, 5, 5, 0));
        long startupTime = this.basicInfo.startUpTime;
        long delta = System.currentTimeMillis() - startupTime;
        long mins = delta / 60000L;
        long hours = mins / 60L;
        long days = hours / 24L;
        panel.add((Component)new JLabel(String.format("%s (%dd %dh %dmin)", FormatUtils.format((long)this.basicInfo.startUpTime), days, hours % 24L, mins % 60L)), new GBC(1, 2).horizontal().northwest().insets(0, 5, 5, 0));
        panel.setBorder(BorderFactory.createTitledBorder(this.getString("border.system")));
        return panel;
    }

    private JPanel buildHostPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.getString("label.host.so")), new GBC(0, 0).none().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(this.basicInfo.operationalSystem), new GBC(1, 0).horizontal().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(this.getString("label.host.id")), new GBC(0, 1).none().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(String.format("%s (%s)", this.basicInfo.hostName, this.basicInfo.hostIP)), new GBC(1, 1).horizontal().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(this.getString("label.host.charset")), new GBC(0, 2).none().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(this.basicInfo.charset), new GBC(1, 2).horizontal().northwest().insets(0, 5, 5, 0));
        panel.setBorder(BorderFactory.createTitledBorder(this.getString("border.host")));
        return panel;
    }

    private JPanel buildJVMPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.getString("label.jvm.version")), new GBC(0, 0).none().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(this.basicInfo.javaVersion), new GBC(1, 0).horizontal().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(this.getString("label.jvm.args")), new GBC(0, 1).none().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(this.basicInfo.javaArgs), new GBC(1, 1).horizontal().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(this.getString("label.rmi.port")), new GBC(0, 2).none().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(String.valueOf(this.basicInfo.rmiPort)), new GBC(1, 2).horizontal().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(this.getString("label.running.path")), new GBC(0, 3).none().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(String.valueOf(this.basicInfo.serverRunningDir)), new GBC(1, 3).horizontal().northwest().insets(0, 5, 5, 0));
        panel.setBorder(BorderFactory.createTitledBorder(this.getString("border.jvm")));
        return panel;
    }

    private JPanel buildLibsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        List<String> tmpList = Arrays.asList(this.basicInfo.serverLibs);
        Collections.sort(tmpList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String s1 = o1;
                String s2 = o2;
                return s1.toLowerCase().compareTo(s2.toLowerCase());
            }
        });
        JList<Object> list = new JList<Object>(tmpList.toArray());
        panel.add((Component)new JScrollPane(list), new GBC(0, 0).both().northwest().insets(0, 5, 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(this.getString("border.libs")));
        return panel;
    }

    private JPanel buildRepositoriesPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.getString("label.repository.projects")), new GBC(0, 0).none().northwest().insets(0, 5, 5, 0));
        JLabel projectRepository = new JLabel(this.basicInfo.projectDir);
        panel.add((Component)projectRepository, new GBC(1, 0).horizontal().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(this.getString("label.repository.algorithms")), new GBC(0, 1).none().northwest().insets(0, 5, 5, 0));
        JLabel algorithmRepository = new JLabel(this.basicInfo.algorithmDir);
        panel.add((Component)algorithmRepository, new GBC(1, 1).horizontal().northwest().insets(0, 5, 5, 0));
        panel.add((Component)new JLabel(this.getString("label.repository.persistency")), new GBC(0, 2).none().northwest().insets(0, 5, 5, 0).pushy());
        JLabel persistencyRepository = new JLabel(this.basicInfo.persistencyDir);
        panel.add((Component)persistencyRepository, new GBC(1, 2).horizontal().northwest().insets(0, 5, 5, 0).pushy());
        panel.setBorder(BorderFactory.createTitledBorder(this.getString("border.repositories")));
        return panel;
    }
}

