/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.TreeFilterPanelListener;
import csbase.client.desktop.dircontents.DirectoryContentsPanel;
import csbase.client.project.ProjectFileTypeComboBox;
import csbase.client.project.ProjectTree;
import csbase.client.util.CountDown;
import csbase.logic.ProjectFileFilter;
import csbase.logic.filters.ProjectFileCompositeAndFilter;
import csbase.logic.filters.ProjectFileNameFilter;
import csbase.logic.filters.ProjectFileRecursiveFilter;
import csbase.logic.filters.ProjectFileTypeFilter;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class TreeFilterPanel
extends JPanel {
    private static final long TEXTFIELD_COUNT_DOWN = 1L;
    private static final TimeUnit TEXTFIELD_COUNT_DOWN_UNIT = TimeUnit.SECONDS;
    private static TreeFilterPanel instance;
    private JTextField filterTextField;
    private ProjectFileTypeComboBox typeComboBox;
    private DirectoryContentsPanel dirContentsPanel;
    private ProjectTree projectTree;
    private JButton clearFieldButton;
    private List<TreeFilterPanelListener> listeners = new ArrayList<TreeFilterPanelListener>();
    private KeyEventDispatcher filterInputDispatcher;

    private TreeFilterPanel(ProjectTree tree, DirectoryContentsPanel panel) {
        super(new GridBagLayout());
        this.projectTree = tree;
        this.dirContentsPanel = panel;
        this.filterTextField = new JTextField(10);
        this.createfilterInputDipatcher(this.filterTextField);
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            public void update() {
                TreeFilterPanel.this.clearFieldButton.setEnabled(TreeFilterPanel.this.filterTextField.getText().length() > 0);
            }
        });
        this.filterTextField.setToolTipText(LNG.get((String)"TreeFilterPanel.filterTextField.tooltip"));
        this.filterTextField.addKeyListener(new KeyAdapter(){
            final CountDown countDown = new CountDown(1L, TreeFilterPanel.access$200(), new Runnable(){

                @Override
                public void run() {
                    SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TreeFilterPanel.this.filterTree();
                        }
                    });
                }
            });

            @Override
            public void keyReleased(KeyEvent e) {
                this.countDown.restart();
            }
        });
        this.clearFieldButton = new JButton(ApplicationImages.ICON_CLEARMSG_16);
        this.clearFieldButton.setMargin(new Insets(0, 0, 0, 0));
        this.clearFieldButton.setEnabled(false);
        this.clearFieldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeFilterPanel.this.filterTextField.setText("");
                TreeFilterPanel.this.clearFieldButton.setEnabled(false);
                TreeFilterPanel.this.filterTextField.requestFocusInWindow();
                TreeFilterPanel.this.filterTree();
            }
        });
        this.typeComboBox = new ProjectFileTypeComboBox(ProjectFileTypeComboBox.Mode.FILE_AND_DIRECTORY, true);
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeFilterPanel.this.filterTree();
            }
        });
        JPanel entryPanel = new JPanel(new GridBagLayout());
        Insets margins = new Insets(5, 5, 5, 5);
        TitledBorder border = BorderFactory.createTitledBorder(LNG.get((String)"TreeFilterPanel.border.title"));
        entryPanel.setBorder(border);
        entryPanel.add((Component)new JLabel(LNG.get((String)"TreeFilterPanel.label.name")), new GBC(0, 0).insets(margins).west());
        entryPanel.add((Component)this.filterTextField, new GBC(1, 0).insets(margins).west().weightx(1.0).horizontal());
        entryPanel.add((Component)this.clearFieldButton, new GBC(2, 0).insets(margins).west());
        entryPanel.add((Component)new JLabel(LNG.get((String)"TreeFilterPanel.label.type")), new GBC(0, 1).insets(margins).west());
        entryPanel.add((Component)this.typeComboBox, new GBC(1, 1).insets(margins).west().weightx(1.0).width(2).horizontal());
        this.add((Component)entryPanel, new GBC(0, 0).both());
    }

    private void addFilterInputDispatcher() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.filterInputDispatcher);
    }

    private void removeFilterInputDispatcher() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.filterInputDispatcher);
    }

    private void createfilterInputDipatcher(final Component cmp) {
        this.filterInputDispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                boolean discardEvent = false;
                if (e.getID() == 400 && cmp.isFocusOwner() && !this.isValid(e.getKeyChar())) {
                    discardEvent = true;
                }
                return discardEvent;
            }

            private boolean isValid(char keyChar) {
                if (Character.isLetterOrDigit(keyChar)) {
                    return true;
                }
                return "?*$._".indexOf(keyChar) >= 0;
            }
        };
    }

    private void filterTree() {
        ProjectFileRecursiveFilter filter;
        int MAX_LENGTH = 10;
        String nameFilter = this.filterTextField.getText();
        StringBuilder appliedFilter = new StringBuilder();
        if (nameFilter.length() > 10) {
            int endIndex = Math.min(nameFilter.length(), 10);
            appliedFilter.append(nameFilter.substring(0, endIndex));
            appliedFilter.append("(...)");
        } else {
            appliedFilter.append(nameFilter);
        }
        String typeFilter = this.typeComboBox.isAllItemSelected() ? null : this.typeComboBox.getSelectedTypeCode();
        appliedFilter.append(" " + LNG.get((String)"UTIL_AND").toUpperCase() + " ");
        appliedFilter.append(typeFilter);
        if (nameFilter.isEmpty() && typeFilter == null) {
            filter = null;
        } else {
            ProjectFileCompositeAndFilter andFilter = new ProjectFileCompositeAndFilter();
            andFilter.addChild((ProjectFileFilter)new ProjectFileNameFilter(nameFilter));
            andFilter.addChild((ProjectFileFilter)new ProjectFileTypeFilter(typeFilter));
            filter = new ProjectFileRecursiveFilter((ProjectFileFilter)andFilter);
        }
        this.dirContentsPanel.setFilter((ProjectFileFilter)filter);
        this.projectTree.setVisualFilter((ProjectFileFilter)filter);
    }

    public void addListener(TreeFilterPanelListener l) {
        this.listeners.add(l);
    }

    public boolean removeListener(TreeFilterPanelListener l) {
        return this.listeners.remove(l);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        super.setVisible(visible);
        if (visible) {
            this.filterTextField.requestFocusInWindow();
            this.addFilterInputDispatcher();
        } else {
            this.reset();
            this.removeFilterInputDispatcher();
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).visibilityChanged(this.isVisible());
        }
    }

    public void reset() {
        String filterText = this.filterTextField.getText();
        this.filterTextField.setText(null);
        if (!filterText.isEmpty() || !this.typeComboBox.isAllItemSelected()) {
            this.typeComboBox.selectAllItem();
        }
    }

    public static TreeFilterPanel getInstance(ProjectTree tree, DirectoryContentsPanel panel) {
        if (instance == null) {
            instance = new TreeFilterPanel(tree, panel);
        }
        return instance;
    }

    static /* synthetic */ TimeUnit access$200() {
        return TEXTFIELD_COUNT_DOWN_UNIT;
    }
}

