/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CountDown
implements Runnable {
    private long count;
    private Runnable task;
    private Lock lock = new ReentrantLock();
    private long started;
    private Thread thread;

    public CountDown(long count, TimeUnit unit, Runnable task) {
        this.count = TimeUnit.MILLISECONDS.convert(count, unit);
        this.task = task;
    }

    public void restart() {
        this.lock.lock();
        try {
            if (this.thread == null) {
                this.thread = new Thread(this);
                this.thread.setDaemon(true);
                this.started = System.currentTimeMillis();
                this.thread.start();
            } else {
                this.started = System.currentTimeMillis();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void run() {
        while (Thread.currentThread().equals(this.thread)) {
            long elapsed;
            this.lock.lock();
            try {
                elapsed = System.currentTimeMillis() - this.started;
                if (elapsed > this.count) {
                    this.thread = null;
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
            try {
                long remaining = this.count - elapsed;
                TimeUnit.MILLISECONDS.sleep(remaining);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.task.run();
    }
}

