/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.csvpanel.menu;

import csbase.client.applications.ApplicationImages;
import csbase.client.util.csvpanel.menu.CSVTablePopupMenu;
import csbase.client.util.csvpanel.table.CSVTable;
import csbase.client.util.csvpanel.table.CSVTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class ColumnHeaderPopupMenu
extends CSVTablePopupMenu {
    private JMenuItem addColumnBeforeItem;
    private JMenuItem addColumnAfterItem;
    private JMenuItem removeColumnItem;

    public ColumnHeaderPopupMenu(CSVTable table) {
        super(table);
        this.createMenu();
    }

    private void createMenu() {
        String addColumnBeforeLabel = this.getString("addColumnBefore.item");
        this.addColumnBeforeItem = new JMenuItem(addColumnBeforeLabel, ApplicationImages.ICON_COLUMNINSERTBEFORE_16);
        this.addColumnBeforeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVTableModel model = ColumnHeaderPopupMenu.this.table.getModel();
                model.addColumn(ColumnHeaderPopupMenu.this.popupCol);
            }
        });
        this.add(this.addColumnBeforeItem);
        String addColumnAfterLabel = this.getString("addColumnAfter.item");
        this.addColumnAfterItem = new JMenuItem(addColumnAfterLabel, ApplicationImages.ICON_COLUMNINSERTAFTER_16);
        this.addColumnAfterItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVTableModel model = ColumnHeaderPopupMenu.this.table.getModel();
                model.addColumn(ColumnHeaderPopupMenu.this.popupCol + 1);
            }
        });
        this.add(this.addColumnAfterItem);
        String removeColumnLabel = this.getString("removeColumn.item");
        this.removeColumnItem = new JMenuItem(removeColumnLabel, ApplicationImages.ICON_COLUMNDELETE_16);
        this.removeColumnItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVTableModel model = ColumnHeaderPopupMenu.this.table.getModel();
                model.removeColumn(ColumnHeaderPopupMenu.this.popupCol);
            }
        });
        this.add(this.removeColumnItem);
    }

    @Override
    protected boolean shouldBeShown() {
        return super.shouldBeShown() && this.table.isEditable() && this.table.getRowCount() > 0;
    }

    @Override
    protected void updateItemStatus() {
        this.removeColumnItem.setEnabled(this.table.getColumnCount() > 1);
    }
}

